/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.ActivityRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.User;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
final class MemoryActivityRepository
implements ActivityRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryActivityRepository.class);
    private final Map<User, List<Event>> events = Maps.createSynchronized();

    MemoryActivityRepository() {
    }

    @Override
    public void saveEvent(Event event, User forUser, LengthOfTime lifetime) throws TException {
        this.checkEvent(event);
        this.checkUser(forUser);
        this.checkLifetime(lifetime);
        User user = forUser;
        List<Event> eventsForUser = this.events.getOrDefault(user, Lists.create());
        eventsForUser.add(event);
        this.events.put(user, eventsForUser);
    }

    @Override
    public boolean containsEvent(@Required String eventId, @Required User user) throws TException {
        this.checkEventId(eventId);
        this.checkUser(user);
        return this.events.getOrDefault(user, Lists.emptyList()).stream().anyMatch(e -> Objects.equal((Object)e.eventId, (Object)eventId));
    }

    @Override
    public Event getEvent(String eventId, User user) throws TException {
        this.checkUser(user);
        this.checkEventId(eventId);
        return this.events.getOrDefault(user, Lists.emptyList()).stream().filter(e -> Objects.equal((Object)e.eventId, (Object)eventId)).findFirst().orElseThrow(() -> new DoesNotExistException("Event does not exist"));
    }

    @Override
    public List<Event> getAllEventsFor(User user) throws TException {
        this.checkUser(user);
        return this.events.getOrDefault(user, Lists.emptyList());
    }

    @Override
    public void deleteEvent(String eventId, User user) throws TException {
        this.checkEventId(eventId);
        this.checkUser(user);
        List eventsForUser = this.events.getOrDefault(user, Lists.emptyList()).stream().filter(e -> !Objects.equal((Object)e.eventId, (Object)eventId)).collect(Collectors.toList());
        this.events.put(user, eventsForUser);
    }

    @Override
    public void deleteAllEventsFor(User user) throws TException {
        this.checkUser(user);
        this.events.remove(user);
    }

    private void checkEvent(Event event) throws InvalidArgumentException {
        Arguments.checkThat((Object)event).throwing(InvalidArgumentException.class).usingMessage("Event cannot be null").is(Assertions.notNull());
        Arguments.checkThat((Object)event.eventId).throwing(InvalidArgumentException.class).usingMessage("eventId must be a valid UUID").is(StringAssertions.validUUID());
    }

    private void checkUser(User user) throws InvalidArgumentException {
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).usingMessage("Invalid User").is(RequestAssertions.validUser());
    }

    private void checkEventId(String eventId) throws InvalidArgumentException {
        Arguments.checkThat((Object)eventId).throwing(InvalidArgumentException.class).usingMessage("EventID missing").is(StringAssertions.nonEmptyString()).usingMessage("Event ID must be a valid UUID").is(StringAssertions.validUUID());
    }

    private void checkLifetime(LengthOfTime lifetime) throws InvalidArgumentException {
        Arguments.checkThat((Object)lifetime).throwing(InvalidArgumentException.class).usingMessage("lifetime cannot be null").is(Assertions.notNull());
        Arguments.checkThat((Object)lifetime.value).throwing(InvalidArgumentException.class).usingMessage("Lifetime cannot be < 0").is(NumberAssertions.greaterThan((long)0L));
    }
}

