/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

public final class ModuleCassandraDevCluster
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleCassandraDevCluster.class);

    protected void configure() {
    }

    @Provides
    ReconnectionPolicy provideReconnectPolicy() {
        long baseAttempt = TimeUnit.SECONDS.toMillis(5L);
        long maxTimeWaiting = TimeUnit.MINUTES.toMillis(1L);
        ExponentialReconnectionPolicy policy = new ExponentialReconnectionPolicy(baseAttempt, maxTimeWaiting);
        return policy;
    }

    @Provides
    @Singleton
    Cluster provideCassandraCluster(ReconnectionPolicy reconnectionPolicy) {
        return Cluster.builder().addContactPoint("cassandra-02.dev.redroma.tech").withPort(9042).withCredentials("cassandra", "NvrCXg300Utn1TBzi5Q9W550I4BeGt").withReconnectionPolicy(reconnectionPolicy).build();
    }

    @Provides
    @Singleton
    Session provideCassandraSession(@Required Cluster cluster) {
        Arguments.checkThat((Object)cluster).is(Assertions.notNull());
        return cluster.connect("Aroma");
    }
}

