/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.Row;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.ActivityRepository;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.data.CredentialRepository;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.MediaRepository;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.OrganizationRepository;
import tech.aroma.data.ReactionRepository;
import tech.aroma.data.TokenRepository;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.data.UserRepository;
import tech.aroma.data.cassandra.CassandraActivityRepository;
import tech.aroma.data.cassandra.CassandraApplicationRepository;
import tech.aroma.data.cassandra.CassandraCredentialsRepository;
import tech.aroma.data.cassandra.CassandraFollowerRepository;
import tech.aroma.data.cassandra.CassandraInboxRepository;
import tech.aroma.data.cassandra.CassandraMediaRepository;
import tech.aroma.data.cassandra.CassandraMessageRepository;
import tech.aroma.data.cassandra.CassandraOrganizationRepository;
import tech.aroma.data.cassandra.CassandraReactionRepository;
import tech.aroma.data.cassandra.CassandraTokenRepository;
import tech.aroma.data.cassandra.CassandraUserPreferencesRepository;
import tech.aroma.data.cassandra.CassandraUserRepository;
import tech.aroma.data.cassandra.Mappers;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.User;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.reactions.Reaction;

public final class ModuleCassandraDataRepositories
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleCassandraDataRepositories.class);

    protected void configure() {
        this.bind(ActivityRepository.class).to(CassandraActivityRepository.class);
        this.bind(ApplicationRepository.class).to(CassandraApplicationRepository.class);
        this.bind(CredentialRepository.class).to(CassandraCredentialsRepository.class);
        this.bind(FollowerRepository.class).to(CassandraFollowerRepository.class);
        this.bind(InboxRepository.class).to(CassandraInboxRepository.class);
        this.bind(MediaRepository.class).to(CassandraMediaRepository.class);
        this.bind(MessageRepository.class).to(CassandraMessageRepository.class);
        this.bind(OrganizationRepository.class).to(CassandraOrganizationRepository.class);
        this.bind(ReactionRepository.class).to(CassandraReactionRepository.class);
        this.bind(TokenRepository.class).to(CassandraTokenRepository.class);
        this.bind(UserRepository.class).to(CassandraUserRepository.class);
        this.bind(UserPreferencesRepository.class).to(CassandraUserPreferencesRepository.class);
    }

    @Provides
    Function<Row, Application> provideApplicationMapper() {
        return Mappers.appMapper();
    }

    @Provides
    Function<Row, Set<MobileDevice>> provideMobileDeviceMapper() {
        return Mappers.mobileDeviceMapper();
    }

    @Provides
    Function<Row, Event> provideEventMapper() {
        return Mappers.eventMapper();
    }

    @Provides
    Function<Row, Image> provideImageMapper() {
        return Mappers.imageMapper();
    }

    @Provides
    Function<Row, Message> provideMessageMapper() {
        return Mappers.messageMapper();
    }

    @Provides
    Function<Row, Organization> provideOrganizationMapper() {
        return Mappers.orgMapper();
    }

    @Provides
    Function<Row, AuthenticationToken> provideTokenMapper() {
        return Mappers.tokenMapper();
    }

    @Provides
    Function<Row, List<Reaction>> provideReactionsMapper() {
        return Mappers.reactionsMapper();
    }

    @Provides
    Function<Row, User> provideUserMapper() {
        return Mappers.userMapper();
    }
}

