/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.ImageType;
import tech.aroma.thrift.Industry;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.ProgrammingLanguage;
import tech.aroma.thrift.Role;
import tech.aroma.thrift.Tier;
import tech.aroma.thrift.Urgency;
import tech.aroma.thrift.User;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.TokenStatus;
import tech.aroma.thrift.authentication.TokenType;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.reactions.Reaction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@NonInstantiable
@Internal
final class Mappers {
    private static final Logger LOG = LoggerFactory.getLogger(Mappers.class);

    Mappers() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    static Function<Row, Application> appMapper() {
        return row -> {
            String tier;
            UUID orgId;
            Date tokenExpiration;
            Date timeOfProvisioning;
            String programmingLanguage;
            UUID iconMediaId;
            Application app = new Application();
            UUID appId = row.getUUID("app_id");
            if (appId != null) {
                app.setApplicationId(appId.toString());
            }
            app.setName(row.getString("name"));
            if (Mappers.doesRowContainColumn(row, "app_description")) {
                app.setApplicationDescription(row.getString("app_description"));
            }
            if (Mappers.doesRowContainColumn(row, "app_icon_media_id") && (iconMediaId = row.getUUID("app_icon_media_id")) != null) {
                app.setApplicationIconMediaId(iconMediaId.toString());
            }
            if (Mappers.doesRowContainColumn(row, "programming_language") && !RequestAssertions.isNullOrEmpty(programmingLanguage = row.getString("programming_language"))) {
                ProgrammingLanguage language = ProgrammingLanguage.valueOf((String)programmingLanguage);
                app.setProgrammingLanguage(language);
            }
            if (Mappers.doesRowContainColumn(row, "time_provisioned") && (timeOfProvisioning = row.getTimestamp("time_provisioned")) != null) {
                app.setTimeOfProvisioning(timeOfProvisioning.getTime());
            }
            if (Mappers.doesRowContainColumn(row, "time_of_token_expiration") && (tokenExpiration = row.getTimestamp("time_of_token_expiration")) != null) {
                app.setTimeOfTokenExpiration(tokenExpiration.getTime());
            }
            if (Mappers.doesRowContainColumn(row, "owners")) {
                Set owners = row.getSet("owners", UUID.class).stream().map(UUID::toString).collect(Collectors.toSet());
                app.setOwners(owners);
            }
            if (Mappers.doesRowContainColumn(row, "organization_id") && (orgId = row.getUUID("organization_id")) != null) {
                app.setOrganizationId(orgId.toString());
            }
            if (Mappers.doesRowContainColumn(row, "tier") && !RequestAssertions.isNullOrEmpty(tier = row.getString("tier"))) {
                app.setTier(Tier.valueOf((String)tier));
            }
            return app;
        };
    }

    static Function<Row, Event> eventMapper() {
        return row -> {
            Date timeOfEvent;
            Event event = new Event();
            UUID eventId = row.getUUID("event_id");
            UUID appId = row.getUUID("app_id");
            UUID actorId = row.getUUID("actor_id");
            String serializedEvent = row.getString("serialized_event");
            if (eventId != null) {
                event.setEventId(eventId.toString());
            }
            if (appId != null) {
                event.setApplicationId(appId.toString());
            }
            if (actorId != null) {
                event.setUserIdOfActor(actorId.toString());
            }
            if ((timeOfEvent = row.getTimestamp("time_of_event")) != null) {
                event.setTimestamp(timeOfEvent.getTime());
            }
            if (!RequestAssertions.isNullOrEmpty(serializedEvent)) {
                try {
                    event = (Event)ThriftObjects.fromJson((TBase)event, (String)serializedEvent);
                }
                catch (TException ex) {
                    LOG.warn("Failed to deserialize {} as an Event", (Object)serializedEvent, (Object)ex);
                }
            }
            return event;
        };
    }

    static Function<Row, Image> imageMapper() {
        return row -> {
            Image image = new Image();
            ByteBuffer binary = row.getBytes("binary");
            image.setData(binary);
            int width = row.getInt("width");
            int height = row.getInt("height");
            image.setDimension(new Dimension(width, height));
            String mediaType = row.getString("media_type");
            try {
                image.setImageType(ImageType.valueOf((String)mediaType));
            }
            catch (Exception ex) {
                LOG.warn("Could not find ImageType: {}", (Object)mediaType, (Object)ex);
            }
            return image;
        };
    }

    static Function<Row, Message> messageMapper() {
        return row -> {
            String urgency;
            Message message = new Message();
            UUID msgId = row.getUUID("message_id");
            UUID appId = row.getUUID("app_id");
            message.setMessageId(msgId.toString()).setApplicationId(appId.toString()).setTitle(row.getString("title")).setDeviceName(row.getString("device_name")).setHostname(row.getString("hostname")).setMacAddress(row.getString("mac_address")).setBody(row.getString("body")).setApplicationName(row.getString("app_name"));
            Date timeCreated = row.getTimestamp("time_created");
            Date timeReceived = row.getTimestamp("time_received");
            if (timeCreated != null) {
                message.setTimeOfCreation(timeCreated.getTime());
            }
            if (timeReceived != null) {
                message.setTimeMessageReceived(timeReceived.getTime());
            }
            if (!RequestAssertions.isNullOrEmpty(urgency = row.getString("urgency"))) {
                message.setUrgency(Urgency.valueOf((String)urgency));
            }
            return message;
        };
    }

    static Function<Row, Organization> orgMapper() {
        return row -> {
            String industry;
            String tier;
            Organization org = new Organization();
            UUID orgUuid = row.getUUID("org_id");
            List owners = Lists.create();
            if (Mappers.doesRowContainColumn(row, "owners")) {
                Set ownerIds = row.getSet("owners", UUID.class);
                owners = ownerIds.stream().map(UUID::toString).collect(Collectors.toList());
            }
            if (!RequestAssertions.isNullOrEmpty(tier = row.getString("tier"))) {
                org.setTier(Tier.valueOf((String)tier));
            }
            if (!RequestAssertions.isNullOrEmpty(industry = row.getString("industry"))) {
                org.setIndustry(Industry.valueOf((String)industry));
            }
            org.setOrganizationId(orgUuid.toString()).setOrganizationName(row.getString("org_name")).setLogoLink(row.getString("icon_link")).setOrganizationDescription(row.getString("description")).setGithubProfile(row.getString("github_profile")).setOrganizationEmail(row.getString("contact_email")).setStockMarketSymbol(row.getString("stock_name")).setWebsite(row.getString("website")).setOwners(owners);
            return org;
        };
    }

    static Function<Row, AuthenticationToken> tokenMapper() {
        return row -> {
            String status;
            String tokenType;
            Date timeOfExpiration;
            AuthenticationToken token = new AuthenticationToken();
            Date timeOfCreation = row.getTimestamp("time_of_creation");
            if (timeOfCreation != null) {
                token.setTimeOfCreation(timeOfCreation.getTime());
            }
            if ((timeOfExpiration = row.getTimestamp("time_of_expiration")) != null) {
                token.setTimeOfExpiration(timeOfExpiration.getTime());
            }
            String orgId = null;
            if (Mappers.doesRowContainColumn(row, "organization_id")) {
                UUID orgUuid = row.getUUID("organization_id");
                String string = orgId = orgUuid != null ? orgUuid.toString() : orgId;
            }
            if (!RequestAssertions.isNullOrEmpty(tokenType = row.getString("token_type"))) {
                token.setTokenType(TokenType.valueOf((String)tokenType));
            }
            if (Mappers.doesRowContainColumn(row, "token_status") && !RequestAssertions.isNullOrEmpty(status = row.getString("token_status"))) {
                token.setStatus(TokenStatus.valueOf((String)status));
            }
            token.setTokenId(row.getUUID("token_id").toString()).setOwnerId(row.getUUID("owner_id").toString()).setOrganizationId(orgId).setOwnerName(row.getString("owner_name"));
            return token;
        };
    }

    static Function<Row, List<Reaction>> reactionsMapper() {
        return row -> {
            List reactions = Lists.create();
            if (!Mappers.doesRowContainColumn(row, "serialized_reactions")) {
                return reactions;
            }
            List serializedReactions = row.getList("serialized_reactions", String.class);
            return serializedReactions.stream().map(Mappers::deserializeReaction).filter(Objects::nonNull).collect(Collectors.toList());
        };
    }

    static Reaction deserializeReaction(String json) {
        try {
            return (Reaction)ThriftObjects.fromJson((TBase)new Reaction(), (String)json);
        }
        catch (TException ex) {
            LOG.warn("Failed to deserialize Reaction: {}", (Object)json, (Object)ex);
            return null;
        }
    }

    static Function<Row, User> userMapper() {
        return row -> {
            Date timeCreated;
            Date birthDate;
            User user = new User();
            String email = null;
            if (Mappers.doesRowContainColumn(row, "email")) {
                email = row.getString("email");
            } else if (Mappers.doesRowContainColumn(row, "emails")) {
                Set emails = row.getSet("emails", String.class);
                email = emails.stream().findFirst().orElse(null);
            }
            if (Mappers.doesRowContainColumn(row, "birthdate") && (birthDate = row.getTimestamp("birthdate")) != null) {
                user.setBirthdate(birthDate.getTime());
            }
            Set roles = Sets.create();
            if (Mappers.doesRowContainColumn(row, "roles")) {
                Set set = row.getSet("roles", String.class);
                roles = Sets.nullToEmpty((Set)set).stream().map(Role::valueOf).collect(Collectors.toSet());
            }
            if (Mappers.doesRowContainColumn(row, "profile_image_id")) {
                String profileImageLink = row.getString("profile_image_id");
                user.setProfileImageLink(profileImageLink);
            }
            if (Mappers.doesRowContainColumn(row, "github_profile")) {
                String githubProfile = row.getString("github_profile");
                user.setGithubProfile(githubProfile);
            }
            if (Mappers.doesRowContainColumn(row, "time_account_created") && (timeCreated = row.getTimestamp("time_account_created")) != null) {
                user.setTimeUserJoined(timeCreated.getTime());
            }
            if (Mappers.doesRowContainColumn(row, "first_name")) {
                user.setFirstName(row.getString("first_name"));
            }
            if (Mappers.doesRowContainColumn(row, "middle_name")) {
                user.setMiddleName(row.getString("middle_name"));
            }
            if (Mappers.doesRowContainColumn(row, "last_name")) {
                user.setLastName(row.getString("last_name"));
            }
            return user.setUserId(row.getUUID("user_id").toString()).setEmail(email).setRoles(roles);
        };
    }

    static Function<Row, Set<MobileDevice>> mobileDeviceMapper() {
        return row -> {
            if (Mappers.doesRowContainColumn(row, "serialized_devices")) {
                Set serializedDevices = row.getSet("serialized_devices", String.class);
                return Sets.nullToEmpty((Set)serializedDevices).stream().map(Mappers::deserializeDevice).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            return Sets.emptySet();
        };
    }

    private static MobileDevice deserializeDevice(String serializedDevice) {
        try {
            return (MobileDevice)ThriftObjects.fromJson((TBase)new MobileDevice(), (String)serializedDevice);
        }
        catch (Exception ex) {
            LOG.error("Failed to Deserialized Device {}", (Object)serializedDevice, (Object)ex);
            return null;
        }
    }

    private static boolean doesRowContainColumn(Row row, String column) {
        try {
            row.isNull(column);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

