/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
@ThreadSafe
final class CassandraUserPreferencesRepository
implements UserPreferencesRepository {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraUserPreferencesRepository.class);
    private final Session cassandra;
    private final Function<Row, Set<MobileDevice>> mobileDeviceMapper;

    @Inject
    CassandraUserPreferencesRepository(Session cassandra, Function<Row, Set<MobileDevice>> mobileDeviceMapper) {
        Arguments.checkThat((Object)cassandra, (Object[])new Object[]{mobileDeviceMapper}).are(Assertions.notNull());
        this.cassandra = cassandra;
        this.mobileDeviceMapper = mobileDeviceMapper;
    }

    @Override
    public void saveMobileDevice(String userId, MobileDevice mobileDevice) throws TException {
        this.checkUserId(userId);
        this.checkMobileDevice(mobileDevice);
        Statement statement = this.createStatementToAddDevice(userId, mobileDevice);
        this.tryToExecute(statement, "saveMobileDevice");
    }

    @Override
    public void saveMobileDevices(String userId, Set<MobileDevice> mobileDevices) throws TException {
        this.checkUserId(userId);
        this.checkMobileDevices(mobileDevices);
        Statement statement = this.createStatementToSaveDevice(userId, mobileDevices);
        this.tryToExecute(statement, "saveMobileDevices");
    }

    @Override
    public Set<MobileDevice> getMobileDevices(String userId) throws TException {
        this.checkUserId(userId);
        Statement query = this.createQueryToGetDevicesFor(userId);
        ResultSet results = this.tryToExecute(query, userId);
        Row row = results.one();
        if (row == null) {
            return Sets.emptySet();
        }
        return this.mobileDeviceMapper.apply(row);
    }

    @Override
    public void deleteMobileDevice(String userId, MobileDevice mobileDevice) throws TException {
        this.checkUserId(userId);
        this.checkMobileDevice(mobileDevice);
        Statement statement = this.createStatementToRemoveDevice(userId, mobileDevice);
        this.tryToExecute(statement, "deleteMobileDevice");
    }

    @Override
    public void deleteAllMobileDevices(String userId) throws TException {
        this.checkUserId(userId);
        Statement statement = this.createStatementToDeleteAllDevicesFor(userId);
        this.tryToExecute(statement, "deleteAllMobileDevices");
    }

    private Statement createStatementToSaveDevice(String userId, Set<MobileDevice> mobileDevices) {
        UUID userUuid = UUID.fromString(userId);
        Set serializedDevices = Sets.nullToEmpty(mobileDevices).stream().map(this::serializeMobileDevice).filter(Objects::nonNull).collect(Collectors.toSet());
        return QueryBuilder.insertInto((String)"User_Preferences").value("user_id", (Object)userUuid).value("serialized_devices", serializedDevices);
    }

    private ResultSet tryToExecute(Statement statement, String operationName) throws OperationFailedException {
        try {
            return this.cassandra.execute(statement);
        }
        catch (Exception ex) {
            LOG.error("Failed to execute operation {} on Cassandra.", (Object)operationName, (Object)ex);
            throw new OperationFailedException("Cassandra Operation Failed: " + ex.getMessage());
        }
    }

    private Statement createQueryToGetDevicesFor(String userId) {
        UUID userUuid = UUID.fromString(userId);
        return QueryBuilder.select().all().from("User_Preferences").where(QueryBuilder.eq((String)"user_id", (Object)userUuid));
    }

    private Statement createStatementToDeleteAllDevicesFor(String userId) {
        UUID userUuid = UUID.fromString(userId);
        return QueryBuilder.delete().all().from("User_Preferences").where(QueryBuilder.eq((String)"user_id", (Object)userUuid));
    }

    private Statement createStatementToAddDevice(String userId, MobileDevice mobileDevice) {
        UUID userUuid = UUID.fromString(userId);
        String serializedDevice = this.serializeMobileDevice(mobileDevice);
        return QueryBuilder.update((String)"User_Preferences").with(QueryBuilder.add((String)"serialized_devices", (Object)serializedDevice)).where(QueryBuilder.eq((String)"user_id", (Object)userUuid));
    }

    private Statement createStatementToRemoveDevice(String userId, MobileDevice mobileDevice) {
        UUID userUuid = UUID.fromString(userId);
        String serializeDevice = this.serializeMobileDevice(mobileDevice);
        return QueryBuilder.update((String)"User_Preferences").with(QueryBuilder.remove((String)"serialized_devices", (Object)serializeDevice)).where(QueryBuilder.eq((String)"user_id", (Object)userUuid));
    }

    private String serializeMobileDevice(MobileDevice device) {
        if (device == null) {
            return null;
        }
        try {
            return ThriftObjects.toJson((TBase)device);
        }
        catch (Exception ex) {
            LOG.error("Failed to Serialize Mobile Device {}", (Object)device, (Object)ex);
            return null;
        }
    }

    private void checkMobileDevice(MobileDevice mobileDevice) throws InvalidArgumentException {
        Arguments.checkThat((Object)mobileDevice).throwing(ex -> new InvalidArgumentException(ex.getMessage())).is(RequestAssertions.validMobileDevice());
    }

    private void checkUserId(String userId) throws InvalidArgumentException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
    }

    private void checkMobileDevices(Set<MobileDevice> mobileDevices) throws InvalidArgumentException {
        Arguments.checkThat(mobileDevices).usingMessage("Mobile Devices cannot be null").throwing(InvalidArgumentException.class).is(Assertions.notNull());
        for (MobileDevice device : mobileDevices) {
            this.checkMobileDevice(device);
        }
    }
}

