/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.assertions;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.User;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.channels.AndroidDevice;
import tech.aroma.thrift.channels.IOSDevice;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.reactions.Reaction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Optional;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.BooleanAssertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
@Internal
public final class RequestAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAssertions.class);

    RequestAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<Application> validApplication() {
        return app -> {
            Arguments.checkThat((Object)app).usingMessage("app is missing").is(Assertions.notNull());
            Arguments.checkThat((Object)app.applicationId, (Object[])new String[]{app.name}).usingMessage("App is missing id and name").are(StringAssertions.nonEmptyString());
            Arguments.checkThat((Object)app.applicationId).is(RequestAssertions.validApplicationId());
            Arguments.checkThat((Object)app.owners).usingMessage("app is missing owners").is(CollectionAssertions.nonEmptySet());
            app.owners.forEach(owner -> Arguments.checkThat((Object)owner).usingMessage("Owner ID must be a valid user ID: " + owner).is(RequestAssertions.validUserId()));
            if (app.isSetOrganizationId()) {
                Arguments.checkThat((Object)app.organizationId).is(RequestAssertions.validOrgId());
            }
        };
    }

    public static AlchemyAssertion<Message> validMessage() {
        return message -> {
            Arguments.checkThat((Object)message).usingMessage("message is missing").is(Assertions.notNull());
            Arguments.checkThat((Object)message.messageId).is(RequestAssertions.validMessageId());
            Arguments.checkThat((Object)message.title).usingMessage("message missing Title").is(StringAssertions.nonEmptyString());
            if (message.isSetApplicationId()) {
                Arguments.checkThat((Object)message.applicationId).is(RequestAssertions.validApplicationId());
            }
        };
    }

    public static AlchemyAssertion<Organization> validOrganization() {
        return org -> {
            Arguments.checkThat((Object)org).usingMessage("org is missing").is(Assertions.notNull());
            Arguments.checkThat((Object)org.organizationId).is(RequestAssertions.validOrgId());
            Arguments.checkThat((Object)org.organizationName).usingMessage("missing organization name").is(StringAssertions.nonEmptyString());
            List owners = Lists.nullToEmpty((List)org.owners);
            for (String owner : owners) {
                Arguments.checkThat((Object)owner).is(RequestAssertions.validUserId());
            }
        };
    }

    public static AlchemyAssertion<User> validUser() {
        return user -> {
            Arguments.checkThat((Object)user).usingMessage("user is missing").is(Assertions.notNull());
            Arguments.checkThat((Object)user.userId).is(RequestAssertions.validUserId());
        };
    }

    public static AlchemyAssertion<String> validApplicationId() {
        return appId -> Arguments.checkThat((Object)appId).usingMessage("missing appId").is(StringAssertions.nonEmptyString()).usingMessage("appId must be a UUID").is(StringAssertions.validUUID());
    }

    public static AlchemyAssertion<AndroidDevice> validAndroidDevice() {
        return android -> {
            Arguments.checkThat((Object)android).usingMessage("Android Device cannot be null").is(Assertions.notNull());
            Arguments.checkThat((Object)android.registrationId).usingMessage("Android Registration ID cannot be empty").is(StringAssertions.nonEmptyString());
        };
    }

    public static AlchemyAssertion<IOSDevice> validiOSDevice() {
        return ios -> {
            Arguments.checkThat((Object)ios).usingMessage("iOS Device cannot be null").is(Assertions.notNull());
            Arguments.checkThat((Object)ios.deviceToken).usingMessage("iOS Device Token cannot be empty").is(Assertions.notNull());
            Arguments.checkThat((Object)ios.getDeviceToken().length).usingMessage("iOS Device Token cannot be empty").is(NumberAssertions.greaterThan((int)0));
        };
    }

    public static AlchemyAssertion<MobileDevice> validMobileDevice() {
        return device -> {
            Arguments.checkThat((Object)device).usingMessage("Mobile Device cannot be null").is(Assertions.notNull());
            Arguments.checkThat((Object)device.isSet()).usingMessage("Mobile Device must be set").is(BooleanAssertions.trueStatement());
            if (device.isSetAndroidDevice()) {
                Arguments.checkThat((Object)device.getAndroidDevice()).is(RequestAssertions.validAndroidDevice());
            }
            if (device.isSetIosDevice()) {
                Arguments.checkThat((Object)device.getIosDevice()).is(RequestAssertions.validiOSDevice());
            }
        };
    }

    public static AlchemyAssertion<String> validMessageId() {
        return msgId -> Arguments.checkThat((Object)msgId).usingMessage("missing messageID").is(StringAssertions.nonEmptyString()).usingMessage("messageID must be a UUID type").is(StringAssertions.validUUID());
    }

    public static AlchemyAssertion<String> validOrgId() {
        return orgId -> Arguments.checkThat((Object)orgId).usingMessage("missing orgId").is(StringAssertions.nonEmptyString()).usingMessage("orgId must be a UUID").is(StringAssertions.validUUID());
    }

    public static AlchemyAssertion<String> validUserId() {
        return userId -> Arguments.checkThat((Object)userId).usingMessage("missing userId").is(StringAssertions.nonEmptyString()).usingMessage("userId must be a UUID").is(StringAssertions.validUUID());
    }

    public static AlchemyAssertion<AuthenticationToken> tokenContainingOwnerId() {
        return token -> {
            Arguments.checkThat((Object)token).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)token.ownerId).usingMessage("token missing ownerId").is(StringAssertions.nonEmptyString());
        };
    }

    public static AlchemyAssertion<LengthOfTime> validLengthOfTime() {
        return time -> {
            Assertions.notNull().check(time);
            Arguments.checkThat((Object)time.value).usingMessage("Time value must be positive").is(NumberAssertions.positiveLong());
            Arguments.checkThat((Object)time.unit).usingMessage("Time is missing unit").is(Assertions.notNull());
        };
    }

    public static AlchemyAssertion<Reaction> validReaction() {
        return reaction -> Arguments.checkThat((Object)reaction).is(Assertions.notNull());
    }

    public static AlchemyAssertion<Image> validImage() {
        return image -> {
            Arguments.checkThat((Object)image).is(Assertions.notNull());
            Arguments.checkThat((Object)image.isSetData()).usingMessage("Image data not set").is(BooleanAssertions.trueStatement());
            Arguments.checkThat((Object)image.getData()).usingMessage("Image missing data").is(Assertions.notNull());
            Arguments.checkThat((Object)image.getData().length).usingMessage("Image data is missing").is(NumberAssertions.positiveInteger());
            if (image.isSetDimension()) {
                Arguments.checkThat((Object)image.dimension.width, (Object[])new Integer[]{image.dimension.height}).usingMessage("width and height must be positive").are(NumberAssertions.positiveInteger());
            }
        };
    }

    public static boolean isNullOrEmpty(@Optional String string) {
        return string == null || string.isEmpty();
    }
}

