/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.assertions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.TokenRepository;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
public final class AuthenticationAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationAssertions.class);

    AuthenticationAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<String> tokenInRepository(@Required TokenRepository repository) throws IllegalArgumentException {
        Arguments.checkThat((Object)repository).usingMessage("repository missing").is(Assertions.notNull());
        return token -> {
            boolean exists;
            try {
                exists = repository.containsToken((String)token);
            }
            catch (Exception ex) {
                throw new FailedAssertionException("Could not check in repository", (Throwable)ex);
            }
            if (!exists) {
                throw new FailedAssertionException("Token does not exist: " + token);
            }
        };
    }

    public static AlchemyAssertion<AuthenticationToken> completeToken() {
        return token -> {
            Arguments.checkThat((Object)token).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)token.tokenId, (Object[])new String[]{token.ownerId}).usingMessage("tokenId and ownerId are required").are(StringAssertions.nonEmptyString());
            Arguments.checkThat((Object)token.tokenType).usingMessage("Token Type is required in token").is(Assertions.notNull());
        };
    }
}

