/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import java.util.Set;
import org.apache.thrift.TException;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;

@StrategyPattern(role=StrategyPattern.Role.INTERFACE)
@ThreadSafe
public interface UserPreferencesRepository {
    default public boolean containsMobileDevice(String userId, MobileDevice mobileDevice) throws TException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
        Arguments.checkThat((Object)mobileDevice).throwing(InvalidArgumentException.class).is(RequestAssertions.validMobileDevice());
        Set<MobileDevice> devices = this.getMobileDevices(userId);
        if (Sets.isEmpty(devices)) {
            return false;
        }
        return devices.contains(mobileDevice);
    }

    public void saveMobileDevice(@NonEmpty String var1, @Required MobileDevice var2) throws TException;

    public void saveMobileDevices(@NonEmpty String var1, @Required Set<MobileDevice> var2) throws TException;

    public Set<MobileDevice> getMobileDevices(@NonEmpty String var1) throws TException;

    public void deleteMobileDevice(@NonEmpty String var1, @Required MobileDevice var2) throws TException;

    public void deleteAllMobileDevices(@NonEmpty String var1) throws TException;
}

