/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import java.util.Collection;
import java.util.List;
import org.apache.thrift.TException;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.TimeUnit;
import tech.sirwellington.alchemy.annotations.arguments.Optional;
import tech.sirwellington.alchemy.annotations.arguments.Required;

public interface MessageRepository {
    default public void saveMessage(@Required Message message) throws TException {
        LengthOfTime defaultTime = new LengthOfTime().setValue(1L).setUnit(TimeUnit.WEEKS);
        this.saveMessage(message, defaultTime);
    }

    public void saveMessage(@Required Message var1, @Optional LengthOfTime var2) throws TException;

    public Message getMessage(@Required String var1, @Required String var2) throws TException;

    public void deleteMessage(@Required String var1, @Required String var2) throws TException;

    default public void deleteAllMessages(@Required String applicationId) throws TException {
        List exceptions = Lists.create();
        this.getByApplication(applicationId).stream().forEach(message -> {
            try {
                this.deleteMessage(applicationId, message.messageId);
            }
            catch (TException ex) {
                exceptions.add(ex);
            }
        });
        if (!Lists.isEmpty((Collection)exceptions)) {
            throw (TException)((Object)Lists.oneOf((List)exceptions));
        }
    }

    public boolean containsMessage(@Required String var1, @Required String var2) throws TException;

    public List<Message> getByHostname(@Required String var1) throws TException;

    public List<Message> getByApplication(@Required String var1) throws TException;

    public List<Message> getByTitle(@Required String var1, @Required String var2) throws TException;

    public long getCountByApplication(@Required String var1) throws TException;
}

