/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import org.apache.thrift.TException;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Required;

public interface MediaRepository {
    public void saveMedia(@NonEmpty String var1, @Required Image var2) throws TException;

    public Image getMedia(@NonEmpty String var1) throws DoesNotExistException, TException;

    default public boolean containsMedia(@NonEmpty String mediaId) throws TException {
        try {
            Image result = this.getMedia(mediaId);
            return result != null;
        }
        catch (DoesNotExistException ex) {
            return false;
        }
    }

    public void deleteMedia(@NonEmpty String var1) throws TException;

    public void saveThumbnail(@NonEmpty String var1, @Required Dimension var2, Image var3) throws TException;

    public Image getThumbnail(@NonEmpty String var1, @Required Dimension var2) throws DoesNotExistException, TException;

    default public boolean containsThumbnail(@NonEmpty String mediaId, @Required Dimension dimension) throws TException {
        try {
            Image thumbnail = this.getThumbnail(mediaId, dimension);
            return thumbnail != null;
        }
        catch (DoesNotExistException ex) {
            return false;
        }
    }

    public void deleteThumbnail(@NonEmpty String var1, @Required Dimension var2) throws TException;

    public void deleteAllThumbnails(@NonEmpty String var1) throws TException;
}

