/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import java.util.Collection;
import java.util.List;
import org.apache.thrift.TException;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.User;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.service.AromaServiceConstants;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;

public interface ActivityRepository {
    default public void saveEvent(Event event, User forUser) throws TException {
        this.saveEvent(event, forUser, AromaServiceConstants.DEFAULT_ACTIVITY_LIFETIME);
    }

    public void saveEvent(Event var1, User var2, LengthOfTime var3) throws TException;

    default public void saveEvents(@Required Event event, List<User> users) throws TException {
        Arguments.checkThat(users).throwing(InvalidArgumentException.class).is(CollectionAssertions.nonEmptyList());
        List exceptions = Lists.create();
        users.parallelStream().forEach(user -> {
            try {
                this.saveEvent(event, (User)user);
            }
            catch (TException ex) {
                exceptions.add(ex);
            }
        });
        if (!Lists.isEmpty((Collection)exceptions)) {
            throw (TException)((Object)Lists.oneOf((List)exceptions));
        }
    }

    public boolean containsEvent(@Required String var1, @Required User var2) throws TException;

    public Event getEvent(@Required String var1, @Required User var2) throws TException;

    public List<Event> getAllEventsFor(@Required User var1) throws TException;

    public void deleteEvent(@Required String var1, @Required User var2) throws TException;

    public void deleteAllEventsFor(@Required User var1) throws TException;
}

