/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.server;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.notnoop.apns.ApnsService;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.application.service.ModuleApplicationService;
import tech.aroma.application.service.server.DoNothingApnsService;
import tech.aroma.data.cassandra.ModuleCassandraDataRepositories;
import tech.aroma.data.cassandra.ModuleCassandraDevCluster;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.notification.service.NotificationService;
import tech.aroma.thrift.services.Clients;
import tech.aroma.thrift.services.NoOpNotificationService;
import tech.sirwellington.alchemy.annotations.access.Internal;

@Internal
public final class TcpServer {
    private static final Logger LOG = LoggerFactory.getLogger(TcpServer.class);
    private static final int PORT = 7002;

    public static void main(String[] args) throws TTransportException, SocketException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AromaServicesProvider(), new ModuleApplicationService(), new ModuleCassandraDataRepositories(), new ModuleCassandraDevCluster()});
        ApplicationService.Iface applicationService = (ApplicationService.Iface)injector.getInstance(ApplicationService.Iface.class);
        ApplicationService.Processor processor = new ApplicationService.Processor(applicationService);
        TServerSocket socket = new TServerSocket(7002);
        socket.getServerSocket().setSoTimeout((int)TimeUnit.SECONDS.toMillis(30L));
        TThreadPoolServer.Args serverArgs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor((TProcessor)processor)).requestTimeout(60).requestTimeoutUnit(TimeUnit.SECONDS).minWorkerThreads(5).maxWorkerThreads(100);
        LOG.info("Starting Application Service at port {}", (Object)7002);
        TThreadPoolServer server = new TThreadPoolServer(serverArgs);
        server.serve();
        server.stop();
    }

    private static class AromaServicesProvider
    extends AbstractModule {
        private AromaServicesProvider() {
        }

        protected void configure() {
        }

        @Provides
        AuthenticationService.Iface provideAuthenticationService() {
            try {
                return Clients.newPerRequestAuthenticationServiceClient();
            }
            catch (TException ex) {
                throw new ProvisionException("Could not create Aroma Service Client", (Throwable)ex);
            }
        }

        @Provides
        NotificationService.Iface provideNotificationService() {
            return new NoOpNotificationService();
        }

        @Provides
        ApnsService provideApnsService() {
            return new DoNothingApnsService();
        }
    }
}

