/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.matchers;

import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.application.service.reactions.matchers.MessageMatcher;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Urgency;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
final class MessageMatchers {
    private static final Logger LOG = LoggerFactory.getLogger(MessageMatchers.class);

    MessageMatchers() {
    }

    static MessageMatcher matchesAll() {
        return message -> true;
    }

    static MessageMatcher matchesNone() {
        return message -> false;
    }

    static MessageMatcher applicationIs(@NonEmpty String appId) {
        Arguments.checkThat((Object)appId).is(RequestAssertions.validApplicationId());
        return message -> {
            if (message == null) {
                return false;
            }
            return Objects.equals(message.applicationId, appId);
        };
    }

    static MessageMatcher applicationIsNot(@NonEmpty String appId) {
        return MessageMatchers.not(MessageMatchers.applicationIs(appId));
    }

    static MessageMatcher not(@Required MessageMatcher matcher) {
        Arguments.checkThat((Object)matcher).is(Assertions.notNull());
        return message -> !matcher.matches(message);
    }

    static MessageMatcher titleContains(@NonEmpty String substring) {
        Arguments.checkThat((Object)substring).is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.title)) {
                return false;
            }
            return message.title.contains(substring);
        };
    }

    static MessageMatcher titleIs(@NonEmpty String title) {
        Arguments.checkThat((Object)title).is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.title)) {
                return false;
            }
            return message.title.equals(title);
        };
    }

    static MessageMatcher titleIsNot(@NonEmpty String title) {
        return MessageMatchers.not(MessageMatchers.titleIs(title));
    }

    static MessageMatcher bodyContains(@NonEmpty String substring) {
        Arguments.checkThat((Object)substring).is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.body)) {
                return false;
            }
            return message.body.contains(substring);
        };
    }

    static MessageMatcher bodyDoesNotContain(@NonEmpty String substring) {
        return MessageMatchers.not(MessageMatchers.bodyContains(substring));
    }

    static MessageMatcher bodyIs(@NonEmpty String expectedBody) {
        Arguments.checkThat((Object)expectedBody).usingMessage("Expected Body cannot be empty").is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.body)) {
                return false;
            }
            return message.body.equals(expectedBody);
        };
    }

    static MessageMatcher hostnameIs(@NonEmpty String expectedHostname) {
        Arguments.checkThat((Object)expectedHostname).usingMessage("Expected Hostname cannot be empty").is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.hostname)) {
                return false;
            }
            return message.hostname.equals(expectedHostname);
        };
    }

    static MessageMatcher hostnameContains(@NonEmpty String substring) {
        Arguments.checkThat((Object)substring).usingMessage("Hostname string cannot be empty").is(StringAssertions.nonEmptyString());
        return message -> {
            if (message == null) {
                return false;
            }
            if (RequestAssertions.isNullOrEmpty((String)message.hostname)) {
                return false;
            }
            return message.hostname.contains(substring);
        };
    }

    static MessageMatcher hostnameDoesNotContain(@NonEmpty String substring) {
        return MessageMatchers.not(MessageMatchers.hostnameContains(substring));
    }

    static MessageMatcher urgencyIs(@Required Urgency urgency) {
        Arguments.checkThat((Object)urgency).usingMessage("Urgency cannot be null").is(Assertions.notNull());
        return message -> {
            if (message == null) {
                return false;
            }
            if (message.urgency == null) {
                return false;
            }
            return message.urgency == urgency;
        };
    }

    static MessageMatcher urgencyIsOneOf(@Required Set<Urgency> urgencies) {
        Arguments.checkThat(urgencies).is(Assertions.notNull());
        return message -> {
            if (message == null) {
                return false;
            }
            if (Sets.isEmpty((Set)urgencies)) {
                return true;
            }
            if (!message.isSetUrgency()) {
                return false;
            }
            return urgencies.contains(message.urgency);
        };
    }
}

