/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.matchers;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.matchers.MatchAlgorithm;
import tech.aroma.application.service.reactions.matchers.MatcherFactory;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.reactions.AromaMatcher;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class MatchAlgorithmAnd
implements MatchAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(MatchAlgorithmAnd.class);
    private final MatcherFactory matcherFactory;

    @Inject
    MatchAlgorithmAnd(MatcherFactory matcherFactory) {
        Arguments.checkThat((Object)matcherFactory).is(Assertions.notNull());
        this.matcherFactory = matcherFactory;
    }

    @Override
    public boolean matches(Message message, List<AromaMatcher> matchers) {
        if (Lists.isEmpty(matchers)) {
            return false;
        }
        List reactionMatchers = matchers.stream().map(this.matcherFactory::matcherFor).filter(Objects::nonNull).collect(Collectors.toList());
        long totalMatches = reactionMatchers.stream().filter(matcher -> matcher.matches(message)).count();
        return totalMatches == (long)matchers.size();
    }

    public String toString() {
        return "AndMatchAlgorithm{matcherFactory=" + this.matcherFactory + '}';
    }
}

