/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.util.List;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.data.InboxRepository;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.aroma.thrift.service.AromaServiceConstants;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class StoreInInboxAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(StoreInInboxAction.class);
    private final InboxRepository inboxRepo;
    private final User user;

    StoreInInboxAction(InboxRepository inboxRepo, User user) {
        Arguments.checkThat((Object)inboxRepo, (Object[])new Object[]{user}).are(Assertions.notNull());
        this.inboxRepo = inboxRepo;
        this.user = user;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Action.checkMessage(message);
        this.inboxRepo.saveMessageForUser(this.user, message, AromaServiceConstants.DEFAULT_INBOX_LIFETIME);
        LOG.debug("Saved Message {}/{} in Inbox of User {}", new Object[]{message.applicationId, message.messageId, this.user});
        return Lists.emptyList();
    }

    public String toString() {
        return "StoreInInboxAction{inboxRepo=" + this.inboxRepo + ", user=" + this.user + '}';
    }
}

