/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.PayloadBuilder;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.channels.IOSDevice;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.channels.PushNotificationPayload;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class SendPushNotificationAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(SendPushNotificationAction.class);
    private final ApnsService apns;
    private final UserPreferencesRepository userPreferencesRepo;
    private final String userId;

    @Inject
    SendPushNotificationAction(ApnsService apns, UserPreferencesRepository userPreferencesRepo, String userId) {
        Arguments.checkThat((Object)apns, (Object[])new Object[]{userPreferencesRepo}).are(Assertions.notNull());
        Arguments.checkThat((Object)userId).is(RequestAssertions.validUserId());
        this.apns = apns;
        this.userPreferencesRepo = userPreferencesRepo;
        this.userId = userId;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).is(RequestAssertions.validMessage());
        this.userPreferencesRepo.getMobileDevices(this.userId).stream().filter(MobileDevice::isSetIosDevice).map(MobileDevice::getIosDevice).filter(Objects::nonNull).forEach(device -> this.sendNotification(message, (IOSDevice)device));
        return Lists.emptyList();
    }

    private void sendNotification(Message message, IOSDevice device) {
        byte[] deviceToken = device.getDeviceToken();
        if (deviceToken == null || deviceToken.length == 0) {
            return;
        }
        byte[] payload = null;
        try {
            payload = this.createNotificationFromMessage(message);
            ApnsNotification response = this.apns.push(deviceToken, payload);
            LOG.debug("Successfully sent Notification to Device: {}", (Object)device);
        }
        catch (Exception ex) {
            LOG.warn("Failed to send Push Notification for: {}", (Object)message.messageId, (Object)ex);
        }
    }

    private byte[] createNotificationFromMessage(Message message) throws TException {
        String alertTitle = message.applicationName;
        String alertBody = String.format("%s - %s", message.applicationName, message.title);
        PushNotificationPayload payload = new PushNotificationPayload().setMessageId(message.messageId).setApplicationId(message.applicationId);
        byte[] serializedPayload = ThriftObjects.toBinary((TBase)payload);
        PayloadBuilder builder = APNS.newPayload().instantDeliveryOrSilentNotification().alertTitle(alertTitle).alertBody(alertBody).customField("aroma.notification.payload", (Object)serializedPayload);
        if (this.notTooLong(builder)) {
            return builder.buildBytes();
        }
        LOG.debug("Apple PNS Payload too long. Shortening: {}", (Object)builder.toString());
        return APNS.newPayload().instantDeliveryOrSilentNotification().alertTitle(alertTitle).alertBody(alertBody).buildBytes();
    }

    private boolean notTooLong(PayloadBuilder builder) {
        return !builder.isTooLong();
    }
}

