/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.time.Instant;
import java.util.List;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.events.ApplicationSentMessage;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.events.EventType;
import tech.aroma.thrift.notification.service.NotificationService;
import tech.aroma.thrift.notification.service.SendNotificationRequest;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class SendNotificationAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(SendNotificationAction.class);
    private final NotificationService.Iface notificationService;

    SendNotificationAction(NotificationService.Iface notificationService) {
        Arguments.checkThat((Object)notificationService).is(Assertions.notNull());
        this.notificationService = notificationService;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Action.checkMessage(message);
        SendNotificationRequest request = this.createNotificationRequestFor(message);
        this.tryToSendNotification(request);
        return Lists.emptyList();
    }

    private SendNotificationRequest createNotificationRequestFor(Message message) {
        ApplicationSentMessage applicationSentMessage = new ApplicationSentMessage().setMessage(message.messageId).setMessage(message.body);
        EventType eventType = new EventType();
        eventType.setApplicationSentMessage(applicationSentMessage);
        String appId = message.applicationId;
        Application app = new Application().setApplicationId(appId);
        Event event = new Event().setApplication(app).setApplicationId(appId).setTimestamp(Instant.now().toEpochMilli()).setEventId("").setEventType(eventType);
        return new SendNotificationRequest().setEvent(event);
    }

    private void tryToSendNotification(SendNotificationRequest sendNotificationRequest) {
        try {
            this.notificationService.sendNotification(sendNotificationRequest);
        }
        catch (TException ex) {
            LOG.warn("Failed to send Notification request: {}", (Object)sendNotificationRequest, (Object)ex);
        }
    }

    public String toString() {
        return "SendNotificationAction{notificationService=" + this.notificationService + '}';
    }
}

