/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionFactory;
import tech.aroma.application.service.reactions.matchers.MatchAlgorithm;
import tech.aroma.data.ReactionRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.aroma.thrift.reactions.AromaAction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
@Internal
final class RunThroughInboxAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(RunThroughInboxAction.class);
    private final ActionFactory actionFactory;
    private final MatchAlgorithm matchAlgorithm;
    private final ReactionRepository reactionRepo;
    private final User user;

    RunThroughInboxAction(ActionFactory actionFactory, MatchAlgorithm matchAlgorithm, ReactionRepository reactionRepo, User user) {
        Arguments.checkThat((Object)actionFactory, (Object[])new Object[]{matchAlgorithm, reactionRepo, user}).are(Assertions.notNull());
        Arguments.checkThat((Object)user).is(RequestAssertions.validUser());
        this.actionFactory = actionFactory;
        this.matchAlgorithm = matchAlgorithm;
        this.reactionRepo = reactionRepo;
        this.user = user;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Action.checkMessage(message);
        List<AromaAction> applicableActions = this.getApplicationActionsFor(message, this.user);
        LOG.debug("Found {} application actions for message {} through Inbox of user {}", new Object[]{applicableActions.size(), message.messageId, this.user.userId});
        boolean shouldStoreInInbox = true;
        boolean shouldSendPushNotification = true;
        List newActions = Lists.create();
        for (AromaAction action : applicableActions) {
            if (action.isSetDontStoreMessage()) {
                shouldStoreInInbox = false;
                continue;
            }
            if (action.isSetSkipInbox()) {
                shouldStoreInInbox = false;
                shouldSendPushNotification = false;
                continue;
            }
            if (action.isSetDontSendPushNotification()) {
                shouldSendPushNotification = false;
                continue;
            }
            if (action.isSetSendPushNotification()) {
                shouldSendPushNotification = true;
                continue;
            }
            Action newAction = this.actionFactory.actionFor(action);
            newActions.add(newAction);
        }
        if (shouldStoreInInbox) {
            Action actionToSaveInInbox = this.actionFactory.actionToStoreInInbox(this.user);
            newActions.add(actionToSaveInInbox);
        }
        if (shouldSendPushNotification) {
            Action actionToSendPushNotification = this.actionFactory.actionToSendPushNotification(this.user.userId);
            newActions.add(actionToSendPushNotification);
            LOG.debug("Sending Push Notifications to {}", (Object)this.user);
        } else {
            LOG.debug("Not Sending Push Notification to {}", (Object)this.user);
        }
        return newActions;
    }

    private List<AromaAction> getApplicationActionsFor(Message message, User user) throws TException {
        List reactions = this.reactionRepo.getReactionsForUser(user.userId);
        reactions = Lists.nullToEmpty((List)reactions);
        return reactions.stream().filter(reaction -> this.matchAlgorithm.matches(message, reaction.matchers)).map(reaction -> reaction.getActions()).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public String toString() {
        return "RunThroughInboxAction{actionFactory=" + this.actionFactory + ", matchAlgorithm=" + this.matchAlgorithm + ", reactionRepo=" + this.reactionRepo + ", user=" + this.user + '}';
    }
}

