/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionFactory;
import tech.aroma.data.FollowerRepository;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class RunThroughFollowerInboxesAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(RunThroughFollowerInboxesAction.class);
    private final ActionFactory factory;
    private final FollowerRepository followerRepo;

    RunThroughFollowerInboxesAction(ActionFactory factory, FollowerRepository followerRepo) {
        Arguments.checkThat((Object)factory, (Object[])new Object[]{followerRepo}).are(Assertions.notNull());
        this.factory = factory;
        this.followerRepo = followerRepo;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Action.checkMessage(message);
        String appId = message.applicationId;
        List followers = this.followerRepo.getApplicationFollowers(appId);
        followers = Lists.nullToEmpty((List)followers);
        LOG.debug("Creating {} additional actions to run through Follower Inboxes for App {}", (Object)followers.size(), (Object)appId);
        return followers.stream().map(user -> this.factory.actionToRunThroughInbox((User)user)).collect(Collectors.toList());
    }

    public String toString() {
        return "RunThroughFollowerInboxesActions{factory=" + this.factory + ", followerRepo=" + this.followerRepo + '}';
    }
}

