/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Urgency;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.reactions.ActionForwardToGitter;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.annotations.objects.Pojo;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NetworkAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttp;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class ForwardToGitterAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardToGitterAction.class);
    private final AlchemyHttp http;
    private final ActionForwardToGitter gitter;

    ForwardToGitterAction(AlchemyHttp http, ActionForwardToGitter gitter) {
        Arguments.checkThat((Object)http, (Object[])new Object[]{gitter}).are(Assertions.notNull());
        Arguments.checkThat((Object)gitter.gitterWebhookUrl).is(StringAssertions.nonEmptyString()).is(NetworkAssertions.validURL());
        this.http = http;
        this.gitter = gitter;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        URL url;
        Action.checkMessage(message);
        try {
            url = new URL(this.gitter.gitterWebhookUrl);
        }
        catch (MalformedURLException ex) {
            LOG.warn("Failed to convert Gitter Webhook to URL", (Throwable)ex);
            throw new InvalidArgumentException("Gitter URL Invalid: " + this.gitter.gitterWebhookUrl);
        }
        GitterMessage gitterMessage = GitterMessage.createFrom(message, this.gitter);
        this.http.go().post().body((Object)gitterMessage).onSuccess(this::onSuccess).onFailure(this::onFailure).at(url);
        return Lists.emptyList();
    }

    private void onSuccess(HttpResponse response) {
        LOG.debug("Successfully posted message to Gitter Webhook");
    }

    private void onFailure(AlchemyHttpException ex) {
        LOG.error("Failed to post to Gitter", (Throwable)ex);
    }

    public String toString() {
        return "ForwardToGitterAction{http=" + this.http + ", gitter=" + this.gitter + '}';
    }

    @Pojo
    @Internal
    static class GitterMessage {
        static final String GITTER_LEVEL_INFO = "info";
        static final String GITTER_LEVEL_ERROR = "error";
        private String message;
        private String level = "info";

        private GitterMessage() {
        }

        private static GitterMessage createFrom(Message message, ActionForwardToGitter gitter) {
            GitterMessage gitterMessage = new GitterMessage();
            if (message.urgency == Urgency.HIGH) {
                gitterMessage.level = GITTER_LEVEL_ERROR;
            }
            gitterMessage.message = String.format("**%s** - *via Aroma*\n**%s**\n\nFrom Device: %s", message.applicationName, message.title, message.hostname);
            if (gitter.includeBody) {
                gitterMessage.message = gitterMessage.message + String.format("\n\n%s", message.body);
            }
            return gitterMessage;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.message);
            hash = 29 * hash + Objects.hashCode(this.level);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GitterMessage other = (GitterMessage)obj;
            if (!Objects.equals(this.message, other.message)) {
                return false;
            }
            return Objects.equals(this.level, other.level);
        }

        public String toString() {
            return "GitterMessage{message=" + this.message + ", level=" + this.level + '}';
        }
    }
}

