/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import com.google.common.collect.Queues;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionRunner;
import tech.aroma.thrift.Message;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class ActionRunnerSynchronous
implements ActionRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRunnerSynchronous.class);

    ActionRunnerSynchronous() {
    }

    @Override
    public int runThroughActions(Message message, List<Action> actions) {
        Action nextAction;
        int totalRuns = 0;
        LinkedBlockingDeque queue = Queues.newLinkedBlockingDeque(actions);
        while (!queue.isEmpty() && (nextAction = (Action)queue.poll()) != null) {
            List<Action> additionalActions = this.runAction(message, nextAction);
            queue.addAll(additionalActions);
            LOG.debug("Pass {} complete with {} additional actions to run through.", (Object)(++totalRuns), (Object)additionalActions.size());
        }
        return totalRuns;
    }

    private List<Action> runAction(Message message, Action action) {
        try {
            return action.actOnMessage(message);
        }
        catch (Exception ex) {
            LOG.error("Failed to run Action {} on Message {}", new Object[]{action, message, ex});
            return Lists.emptyList();
        }
    }
}

