/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import com.notnoop.apns.ApnsService;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionFactory;
import tech.aroma.application.service.reactions.actions.DoNothingAction;
import tech.aroma.application.service.reactions.actions.ForwardToGitterAction;
import tech.aroma.application.service.reactions.actions.ForwardToSlackChannelAction;
import tech.aroma.application.service.reactions.actions.RunThroughFollowerInboxesAction;
import tech.aroma.application.service.reactions.actions.RunThroughInboxAction;
import tech.aroma.application.service.reactions.actions.SendNotificationAction;
import tech.aroma.application.service.reactions.actions.SendPushNotificationAction;
import tech.aroma.application.service.reactions.actions.StoreInInboxAction;
import tech.aroma.application.service.reactions.actions.StoreMessageAction;
import tech.aroma.application.service.reactions.matchers.MatchAlgorithm;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.ReactionRepository;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.aroma.thrift.notification.service.NotificationService;
import tech.aroma.thrift.reactions.ActionForwardToGitter;
import tech.aroma.thrift.reactions.ActionForwardToSlackChannel;
import tech.aroma.thrift.reactions.ActionForwardToSlackUser;
import tech.aroma.thrift.reactions.ActionSendEmail;
import tech.aroma.thrift.reactions.AromaAction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.FactoryPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NetworkAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttp;

@Internal
@FactoryPattern(role=FactoryPattern.Role.FACTORY)
final class ActionFactoryImpl
implements ActionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ActionFactoryImpl.class);
    private final AlchemyHttp http;
    private final ApnsService apns;
    private final FollowerRepository followerRepo;
    private final InboxRepository inboxRepo;
    private final MatchAlgorithm matchAlgorithm;
    private final MessageRepository messageRepo;
    private final ReactionRepository reactionRepo;
    private final UserPreferencesRepository userPreferencesRepo;
    private final NotificationService.Iface notificationService;

    @Inject
    ActionFactoryImpl(AlchemyHttp http, ApnsService apns, FollowerRepository followerRepo, InboxRepository inboxRepo, MatchAlgorithm matchAlgorithm, MessageRepository messageRepo, ReactionRepository reactionRepo, UserPreferencesRepository userPreferencesRepo, NotificationService.Iface notificationService) {
        Arguments.checkThat((Object)http, (Object[])new Object[]{apns, followerRepo, inboxRepo, matchAlgorithm, messageRepo, reactionRepo, userPreferencesRepo, notificationService}).are(Assertions.notNull());
        this.http = http;
        this.apns = apns;
        this.followerRepo = followerRepo;
        this.inboxRepo = inboxRepo;
        this.matchAlgorithm = matchAlgorithm;
        this.messageRepo = messageRepo;
        this.reactionRepo = reactionRepo;
        this.userPreferencesRepo = userPreferencesRepo;
        this.notificationService = notificationService;
    }

    @Override
    public Action actionFor(AromaAction action) {
        if (action == null) {
            return this.actionToDoNothing();
        }
        if (action.isSetForwardToSlackChannel()) {
            return this.actionToSendToSlackChannel(action.getForwardToSlackChannel());
        }
        if (action.isSetForwardToSlackUser()) {
            return this.actionToSendToSlackUser(action.getForwardToSlackUser());
        }
        if (action.isSetForwardToGitter()) {
            return this.actionToSendToGitter(action.getForwardToGitter());
        }
        if (action.isSetSendEmail()) {
            return this.actionToSendEmail(action.getSendEmail());
        }
        return this.actionToDoNothing();
    }

    @Override
    public Action actionToDoNothing() {
        return new DoNothingAction();
    }

    @Override
    public Action actionToSendToGitter(ActionForwardToGitter gitter) {
        Arguments.checkThat((Object)gitter).is(Assertions.notNull());
        Arguments.checkThat((Object)gitter.gitterWebhookUrl).usingMessage("Gitter Webhook not a valid URL: " + gitter.gitterWebhookUrl).is(NetworkAssertions.validURL());
        return new ForwardToGitterAction(this.http, gitter);
    }

    @Override
    public Action actionToSendToSlackChannel(ActionForwardToSlackChannel slack) {
        return new ForwardToSlackChannelAction(slack, this.http);
    }

    @Override
    public Action actionToSendToSlackUser(ActionForwardToSlackUser slack) {
        return this.actionToDoNothing();
    }

    @Override
    public Action actionToSendNotifications(Message message) {
        return new SendNotificationAction(this.notificationService);
    }

    @Override
    public Action actionToRunThroughFollowerInboxes(Message message) {
        return new RunThroughFollowerInboxesAction(this, this.followerRepo);
    }

    @Override
    public Action actionToRunThroughInbox(User user) {
        return new RunThroughInboxAction(this, this.matchAlgorithm, this.reactionRepo, user);
    }

    @Override
    public Action actionToStoreMessage(Message message) {
        return new StoreMessageAction(this.messageRepo);
    }

    @Override
    public Action actionToStoreInInbox(User user) {
        return new StoreInInboxAction(this.inboxRepo, user);
    }

    @Override
    public Action actionToSendEmail(ActionSendEmail sendEmail) {
        return new DoNothingAction();
    }

    @Override
    public Action actionToSendPushNotification(String userId) {
        return new SendPushNotificationAction(this.apns, this.userPreferencesRepo, userId);
    }
}

