/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import decorice.DecoratorModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.application.service.ApplicationServiceBase;
import tech.aroma.application.service.AuthenticationLayer;
import tech.aroma.application.service.operations.ModuleApplicationServiceOperations;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.sirwellington.alchemy.http.AlchemyHttp;

public final class ModuleApplicationService
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleApplicationService.class);

    protected void configure() {
        this.install((Module)new ModuleApplicationServiceOperations());
        this.install((Module)new ServiceModule());
        this.bind(ExecutorService.class).toInstance((Object)Executors.newWorkStealingPool(8));
    }

    @Singleton
    @Provides
    AlchemyHttp provideHttpClient(ExecutorService executor) {
        return AlchemyHttp.newBuilder().enableAsyncCallbacks().usingExecutorService(executor).usingTimeout(45, TimeUnit.SECONDS).build();
    }

    private static class ServiceModule
    extends DecoratorModule {
        private ServiceModule() {
            this.bind(ApplicationService.Iface.class).to(ApplicationServiceBase.class).decoratedBy(AuthenticationLayer.class, new Class[0]);
        }
    }
}

