/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service;

import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.application.service.ApplicationAssertions;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.aroma.thrift.application.service.SendMessageRequest;
import tech.aroma.thrift.application.service.SendMessageResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidCredentialsException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.thrift.operations.ThriftOperation;

@Internal
@DecoratorPattern(role=DecoratorPattern.Role.CONCRETE_COMPONENT)
final class ApplicationServiceBase
implements ApplicationService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationServiceBase.class);
    private final ThriftOperation<SendMessageRequest, SendMessageResponse> sendMessageOperation;
    private final ExecutorService executor;

    @Inject
    ApplicationServiceBase(ThriftOperation<SendMessageRequest, SendMessageResponse> sendMessageOperation, ExecutorService executor) {
        Arguments.checkThat((Object)executor, (Object[])new Object[]{sendMessageOperation}).are(Assertions.notNull());
        this.sendMessageOperation = sendMessageOperation;
        this.executor = executor;
    }

    public double getApiVersion() throws TException {
        return 2.01;
    }

    public SendMessageResponse sendMessage(SendMessageRequest request) throws OperationFailedException, InvalidArgumentException, InvalidCredentialsException, TException {
        Arguments.checkThat((Object)request).throwing(ApplicationAssertions.withMessage("request is missing")).is(Assertions.notNull());
        SendMessageRequest requestWithoutBody = new SendMessageRequest(request).setBody(null);
        LOG.debug("Received request to send message: {}", (Object)requestWithoutBody);
        return (SendMessageResponse)this.sendMessageOperation.process((TBase)request);
    }

    public void sendMessageAsync(SendMessageRequest request) throws TException {
        if (request == null) {
            LOG.warn("Received null request");
            return;
        }
        this.executor.submit(() -> this.sendMessage(request));
    }
}

