/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.matchers;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.application.service.reactions.matchers.MatcherFactory;
import tech.aroma.application.service.reactions.matchers.MessageMatcher;
import tech.aroma.application.service.reactions.matchers.MessageMatchers;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.reactions.AromaMatcher;
import tech.sirwellington.alchemy.annotations.designs.patterns.FactoryPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@FactoryPattern(role=FactoryPattern.Role.FACTORY)
final class MatcherFactoryImpl
implements MatcherFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherFactoryImpl.class);

    MatcherFactoryImpl() {
    }

    @Override
    public MessageMatcher matcherFor(AromaMatcher matcher) {
        if (matcher == null || matcher.isSetAll()) {
            return MessageMatchers.matchesAll();
        }
        if (matcher.isSetApplicationIs()) {
            String appId = matcher.getApplicationIs().getAppId();
            Arguments.checkThat((Object)appId).is(RequestAssertions.validApplicationId());
            return MessageMatchers.applicationIs(appId);
        }
        if (matcher.isSetApplicationIsNot()) {
            String appId = matcher.getApplicationIsNot().getAppId();
            Arguments.checkThat((Object)appId).is(RequestAssertions.validApplicationId());
            return MessageMatchers.applicationIsNot(appId);
        }
        if (matcher.isSetBodyContains()) {
            String substring = matcher.getBodyContains().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Matcher substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.bodyContains(substring);
        }
        if (matcher.isSetBodyDoesNotContain()) {
            String substring = matcher.getBodyDoesNotContain().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Matcher substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.bodyDoesNotContain(substring);
        }
        if (matcher.isSetBodyIs()) {
            String expectedBody = matcher.getBodyIs().getExpectedBody();
            Arguments.checkThat((Object)expectedBody).usingMessage("Expected Body cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.bodyIs(expectedBody);
        }
        if (matcher.isSetTitleContains()) {
            String substring = matcher.getTitleContains().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Matcher substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.titleContains(substring);
        }
        if (matcher.isSetTitleDoesNotContain()) {
            String substring = matcher.getTitleDoesNotContain().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Matcher substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.not(MessageMatchers.titleContains(substring));
        }
        if (matcher.isSetTitleIs()) {
            String expectedTitle = matcher.getTitleIs().getExpectedTitle();
            Arguments.checkThat((Object)expectedTitle).usingMessage("Expected Message Title cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.titleIs(expectedTitle);
        }
        if (matcher.isSetTitleIsNot()) {
            String title = matcher.getTitleIsNot().getTitle();
            Arguments.checkThat((Object)title).usingMessage("Message Title cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.titleIsNot(title);
        }
        if (matcher.isSetUrgencyEquals()) {
            Set expectedUrgencies = Sets.nullToEmpty((Set)matcher.getUrgencyEquals().getPossibleUrgencies());
            Arguments.checkThat((Object)expectedUrgencies).usingMessage("Expected Urgency cannot be empty").is(CollectionAssertions.nonEmptySet());
            return MessageMatchers.urgencyIsOneOf(expectedUrgencies);
        }
        if (matcher.isSetHostnameIs()) {
            String expectedHostname = matcher.getHostnameIs().getExpectedHostname();
            Arguments.checkThat((Object)expectedHostname).usingMessage("Expected Hostname cannote be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.hostnameIs(expectedHostname);
        }
        if (matcher.isSetHostnameContains()) {
            String substring = matcher.getHostnameContains().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Hostname substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.hostnameContains(substring);
        }
        if (matcher.isSetHostnameDoesNotContain()) {
            String substring = matcher.getHostnameDoesNotContain().getSubstring();
            Arguments.checkThat((Object)substring).usingMessage("Hostname substring cannot be empty").is(StringAssertions.nonEmptyString());
            return MessageMatchers.hostnameDoesNotContain(substring);
        }
        return MessageMatchers.matchesNone();
    }
}

