/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import java.util.List;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.data.MessageRepository;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.TimeUnit;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class StoreMessageAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMessageAction.class);
    private final MessageRepository messageRepo;

    StoreMessageAction(MessageRepository messageRepo) {
        Arguments.checkThat((Object)messageRepo).is(Assertions.notNull());
        this.messageRepo = messageRepo;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        Action.checkMessage(message);
        this.messageRepo.saveMessage(message, new LengthOfTime(TimeUnit.HOURS, 18L));
        LOG.debug("Saved message in Message Repo: {}", (Object)message);
        return Lists.emptyList();
    }

    public String toString() {
        return "StoreMessageAction{messageRepo=" + this.messageRepo + '}';
    }
}

