/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.aroma.thrift.reactions.ActionForwardToSlackChannel;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.annotations.objects.Pojo;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NetworkAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttp;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class ForwardToSlackChannelAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardToSlackChannelAction.class);
    private final ActionForwardToSlackChannel slack;
    private final AlchemyHttp http;

    ForwardToSlackChannelAction(ActionForwardToSlackChannel slack, AlchemyHttp http) {
        Arguments.checkThat((Object)slack, (Object[])new Object[]{http}).are(Assertions.notNull());
        this.slack = slack;
        this.http = http;
    }

    @Override
    public List<Action> actOnMessage(Message message) throws TException {
        URL webhookUrl;
        Action.checkMessage(message);
        Arguments.checkThat((Object)this.slack.webhookUrl).throwing(InvalidArgumentException.class).usingMessage("Slack Webhook URL is not a valid URL: " + this.slack.webhookUrl).is(NetworkAssertions.validURL());
        Payload payload = this.createPayloadFor(message);
        try {
            webhookUrl = new URL(this.slack.webhookUrl);
        }
        catch (MalformedURLException ex) {
            LOG.error("Failed to convert Slack Webhook URL: {}", (Object)this.slack.webhookUrl, (Object)ex);
            throw new OperationFailedException("Could not convert URL: " + ex.getMessage());
        }
        LOG.debug("Sending Message Payload to {} for Message {}", (Object)webhookUrl, (Object)message.title);
        this.http.go().post().body((Object)payload).accept("application/json", new String[]{"text/plain", "text/javascript"}).onSuccess(this::onSuccess).onFailure(this::onFailure).at(webhookUrl);
        return Lists.emptyList();
    }

    private void onSuccess(HttpResponse response) {
        LOG.debug("Successfully sent Slack Message | {}", (Object)response);
    }

    private void onFailure(AlchemyHttpException ex) {
        LOG.error("Failed to post Slack Message to {}", (Object)this.slack, (Object)ex);
    }

    private Payload createPayloadFor(Message message) {
        Field titleField = new Field();
        titleField.title = message.title;
        titleField.value = message.body;
        Field deviceField = new Field();
        deviceField.title = "From Device";
        deviceField.value = message.hostname;
        Attachment attachment = new Attachment();
        switch (message.urgency) {
            case HIGH: {
                attachment.color = "#FB3E3C";
                break;
            }
            case MEDIUM: {
                attachment.color = "#F8E71C";
                break;
            }
            default: {
                attachment.color = "#037AFF";
            }
        }
        attachment.fields = Lists.createFrom((Object)titleField, (Object[])new Field[]{deviceField});
        Payload payload = new Payload();
        payload.attachments.add(attachment);
        payload.text = String.format("*%s* - %s", message.applicationName, message.title);
        if (!Strings.isNullOrEmpty((String)this.slack.slackChannel)) {
            payload.channel = this.slack.slackChannel;
        }
        return payload;
    }

    public String toString() {
        return "ForwardToSlackChannelAction{slack=" + this.slack + ", http=" + this.http + '}';
    }

    @Pojo
    @Internal
    static class Field {
        private String title;
        private String value;
        private boolean isShort = false;

        Field() {
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + Objects.hashCode(this.title);
            hash = 97 * hash + Objects.hashCode(this.value);
            hash = 97 * hash + (this.isShort ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            if (this.isShort != other.isShort) {
                return false;
            }
            if (!Objects.equals(this.title, other.title)) {
                return false;
            }
            return Objects.equals(this.value, other.value);
        }

        public String toString() {
            return "Field{title=" + this.title + ", value=" + this.value + ", isShort=" + this.isShort + '}';
        }
    }

    @Pojo
    @Internal
    static class Attachment {
        private static final String COLOR_LOW = "#037AFF";
        private static final String COLOR_MEDIUM = "#F8E71C";
        private static final String COLOR_HIGH = "#FB3E3C";
        private String fallback;
        private String pretext;
        private String color;
        private List<Field> fields = Lists.create();

        Attachment() {
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.fallback);
            hash = 71 * hash + Objects.hashCode(this.pretext);
            hash = 71 * hash + Objects.hashCode(this.color);
            hash = 71 * hash + Objects.hashCode(this.fields);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attachment other = (Attachment)obj;
            if (!Objects.equals(this.fallback, other.fallback)) {
                return false;
            }
            if (!Objects.equals(this.pretext, other.pretext)) {
                return false;
            }
            if (!Objects.equals(this.color, other.color)) {
                return false;
            }
            return Objects.equals(this.fields, other.fields);
        }

        public String toString() {
            return "Attachment{fallback=" + this.fallback + ", pretext=" + this.pretext + ", color=" + this.color + ", fields=" + this.fields + '}';
        }
    }

    @Pojo
    @Internal
    static class Payload {
        private String icon_url = "https://raw.githubusercontent.com/RedRoma/Aroma/develop/Graphics/Logo.png";
        private String username = "Aroma";
        private String text = null;
        private String channel;
        private Boolean mrkdwn = true;
        private List<Attachment> attachments = Lists.create();

        Payload() {
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.icon_url);
            hash = 17 * hash + Objects.hashCode(this.username);
            hash = 17 * hash + Objects.hashCode(this.text);
            hash = 17 * hash + Objects.hashCode(this.attachments);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Payload other = (Payload)obj;
            if (!Objects.equals(this.icon_url, other.icon_url)) {
                return false;
            }
            if (!Objects.equals(this.username, other.username)) {
                return false;
            }
            if (!Objects.equals(this.text, other.text)) {
                return false;
            }
            return Objects.equals(this.attachments, other.attachments);
        }

        public String toString() {
            return "Payload{icon_url=" + this.icon_url + ", username=" + this.username + ", text=" + this.text + ", attachments=" + this.attachments + '}';
        }
    }
}

