/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions.actions;

import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionRunner;
import tech.aroma.thrift.Message;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;

@Internal
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class ActionRunnerAsynchronous
implements ActionRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRunnerAsynchronous.class);

    ActionRunnerAsynchronous() {
    }

    @Override
    public int runThroughActions(Message message, List<Action> actions) {
        int totalRuns = 0;
        LinkedBlockingDeque queue = Queues.newLinkedBlockingDeque(actions);
        while (!queue.isEmpty()) {
            List additionalActions = queue.parallelStream().map(action -> this.tryToRunActionOnMessage((Action)action, message)).flatMap(Collection::stream).collect(Collectors.toList());
            queue.clear();
            LOG.debug("Pass {} complete with {} additional actions to run through.", (Object)(++totalRuns), (Object)additionalActions.size());
            queue.addAll(additionalActions);
        }
        return totalRuns;
    }

    private List<Action> tryToRunActionOnMessage(Action action, Message message) {
        try {
            return action.actOnMessage(message);
        }
        catch (Exception ex) {
            LOG.error("Failed to run Action {} on Message {}", new Object[]{action, message, ex});
            return Lists.emptyList();
        }
    }
}

