/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.reactions;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.application.service.reactions.MessageReactor;
import tech.aroma.application.service.reactions.actions.Action;
import tech.aroma.application.service.reactions.actions.ActionFactory;
import tech.aroma.application.service.reactions.actions.ActionRunner;
import tech.aroma.application.service.reactions.matchers.MatchAlgorithm;
import tech.aroma.data.ReactionRepository;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.application.service.SendMessageResponse;
import tech.aroma.thrift.reactions.AromaAction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@Internal
@ThreadSafe
final class MessageReactorImpl
implements MessageReactor {
    private static final Logger LOG = LoggerFactory.getLogger(MessageReactorImpl.class);
    private final ActionRunner actionRunner;
    private final ActionFactory actionFactory;
    private final MatchAlgorithm matchAlgorithm;
    private final ReactionRepository reactionRepo;

    @Inject
    MessageReactorImpl(ActionRunner actionRunner, ActionFactory actionFactory, MatchAlgorithm matchAlgorithm, ReactionRepository reactionRepo) {
        Arguments.checkThat((Object)actionRunner, (Object[])new Object[]{actionFactory, matchAlgorithm, reactionRepo}).are(Assertions.notNull());
        this.actionRunner = actionRunner;
        this.actionFactory = actionFactory;
        this.matchAlgorithm = matchAlgorithm;
        this.reactionRepo = reactionRepo;
    }

    @Override
    public SendMessageResponse reactToMessage(@Required Message message) throws TException {
        Action.checkMessage(message);
        List<AromaAction> applicableActions = this.getAllActionsApplicableToMessage(message);
        LOG.debug("Found {} applicable actions for Message {}", (Object)applicableActions.size(), (Object)message.messageId);
        boolean shouldRunThroughInboxes = true;
        boolean shouldStoreMessage = true;
        List initialActions = Lists.create();
        for (AromaAction action : applicableActions) {
            if (action.isSetSkipInbox()) {
                shouldRunThroughInboxes = false;
                continue;
            }
            if (action.isSetDontStoreMessage()) {
                shouldStoreMessage = false;
                continue;
            }
            Action newAction = this.actionFactory.actionFor(action);
            initialActions.add(newAction);
        }
        if (shouldStoreMessage) {
            Action actionToStoreMessage = this.actionFactory.actionToStoreMessage(message);
            initialActions.add(actionToStoreMessage);
        }
        if (shouldRunThroughInboxes) {
            Action actionToRunThroughFollowerInboxes = this.actionFactory.actionToRunThroughFollowerInboxes(message);
            initialActions.add(actionToRunThroughFollowerInboxes);
        }
        LOG.debug("Processing Message with {} initial actions: [{}]", (Object)initialActions.size(), (Object)message.messageId);
        int totalActions = this.actionRunner.runThroughActions(message, initialActions);
        LOG.debug("Ran through {} total actions for Message {}", (Object)totalActions, (Object)message.messageId);
        return new SendMessageResponse().setMessageId(message.messageId);
    }

    private List<AromaAction> getAllActionsApplicableToMessage(Message message) throws TException {
        String appId = message.applicationId;
        List reactions = this.reactionRepo.getReactionsForApplication(appId);
        return Lists.nullToEmpty((List)reactions).stream().filter(reaction -> this.matchAlgorithm.matches(message, reaction.matchers)).filter(reaction -> !Lists.isEmpty((Collection)reaction.actions)).flatMap(reaction -> reaction.actions.stream()).distinct().collect(Collectors.toList());
    }
}

