/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.operations;

import com.datastax.driver.core.utils.UUIDs;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.application.service.reactions.MessageReactor;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.application.service.SendMessageRequest;
import tech.aroma.thrift.application.service.SendMessageResponse;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.TokenType;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.GetTokenInfoRequest;
import tech.aroma.thrift.authentication.service.GetTokenInfoResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.Checks;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.operations.ThriftOperation;

final class SendMessageOperation
implements ThriftOperation<SendMessageRequest, SendMessageResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SendMessageOperation.class);
    private final AuthenticationService.Iface authenticationService;
    private final MessageReactor messageReactor;
    private final Function<AuthenticationToken, ApplicationToken> tokenMapper;

    @Inject
    SendMessageOperation(AuthenticationService.Iface authenticationService, MessageReactor messageReactor, Function<AuthenticationToken, ApplicationToken> tokenMapper) {
        Arguments.checkThat((Object)authenticationService, (Object[])new Object[]{tokenMapper, messageReactor}).are(Assertions.notNull());
        this.authenticationService = authenticationService;
        this.messageReactor = messageReactor;
        this.tokenMapper = tokenMapper;
    }

    public SendMessageResponse process(SendMessageRequest request) throws TException {
        Arguments.checkThat((Object)request).throwing(ex -> new InvalidArgumentException(ex.getMessage())).is(this.good());
        ApplicationToken appToken = this.tryToGetTokenInfo(request.applicationToken);
        String applicationId = appToken.applicationId;
        this.checkAppId(applicationId);
        Message message = this.createMessageFrom(request, appToken);
        this.messageReactor.reactToMessage(message);
        SendMessageResponse response = new SendMessageResponse().setMessageId(message.messageId);
        return response;
    }

    private ApplicationToken tryToGetTokenInfo(ApplicationToken applicationToken) throws InvalidTokenException, OperationFailedException {
        ApplicationToken appToken;
        GetTokenInfoResponse tokenInfo;
        GetTokenInfoRequest getTokenInfoRequest = new GetTokenInfoRequest().setTokenId(applicationToken.tokenId).setTokenType(TokenType.APPLICATION);
        try {
            tokenInfo = this.authenticationService.getTokenInfo(getTokenInfoRequest);
        }
        catch (InvalidTokenException ex) {
            LOG.warn("Application Token is Invalid: [{}]", (Object)applicationToken, (Object)ex);
            throw ex;
        }
        catch (TException ex) {
            LOG.error("Failed to get info for Token [{}]", (Object)applicationToken, (Object)ex);
            throw new OperationFailedException("Could not get token info: " + ex.getMessage());
        }
        Arguments.checkThat((Object)tokenInfo, (Object[])new TBase[]{tokenInfo.token}).throwing(OperationFailedException.class).usingMessage("AuthenticationService Response is missing Token Info").are(Assertions.notNull());
        Arguments.checkThat((Object)tokenInfo.token.ownerId).throwing(OperationFailedException.class).usingMessage("missing Token Info").is(StringAssertions.nonEmptyString());
        try {
            appToken = this.tokenMapper.apply(tokenInfo.token);
        }
        catch (Exception ex) {
            LOG.error("Failed to map Auth Token {} to App Token", (Object)tokenInfo.token, (Object)ex);
            throw new OperationFailedException("Could not map Auth Token to App Token: " + ex.getMessage());
        }
        Arguments.checkThat((Object)appToken).throwing(OperationFailedException.class).usingMessage("Could not map Auth Token to App Token").is(Assertions.notNull());
        return appToken;
    }

    private Message createMessageFrom(SendMessageRequest request, ApplicationToken token) {
        String body;
        UUID messageId = UUIDs.timeBased();
        if (request.title.length() > 40) {
            request.setTitle(request.title.substring(0, 40));
        }
        if (!Checks.Internal.isNullOrEmpty((String)(body = request.body)) && body.length() > 15000) {
            body = body.substring(0, 15000);
        }
        Message message = new Message().setApplicationId(token.applicationId).setApplicationName(token.applicationName).setMessageId(messageId.toString()).setBody(body).setTitle(request.title).setUrgency(request.urgency).setTimeOfCreation(request.timeOfMessage).setTimeMessageReceived(Instant.now().toEpochMilli()).setHostname(request.hostname).setMacAddress(request.macAddress);
        return message;
    }

    private AlchemyAssertion<SendMessageRequest> good() {
        return request -> {
            Arguments.checkThat((Object)request).is(Assertions.notNull());
            Arguments.checkThat((Object)request.applicationToken).usingMessage("Missing Application Token").is(Assertions.notNull());
            Arguments.checkThat((Object)request.title).usingMessage("Missing Message Title").is(StringAssertions.nonEmptyString());
        };
    }

    private void checkAppId(String applicationId) throws OperationFailedException {
        Arguments.checkThat((Object)applicationId).throwing(OperationFailedException.class).usingMessage("Could not get Application ID from Token").is(RequestAssertions.validApplicationId());
    }
}

