/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service.operations;

import com.datastax.driver.core.utils.UUIDs;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.UserRepository;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.TimeUnit;
import tech.aroma.thrift.User;
import tech.aroma.thrift.application.service.SendMessageRequest;
import tech.aroma.thrift.application.service.SendMessageResponse;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.TokenType;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.GetTokenInfoRequest;
import tech.aroma.thrift.authentication.service.GetTokenInfoResponse;
import tech.aroma.thrift.events.ApplicationSentMessage;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.events.EventType;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.aroma.thrift.functions.TokenFunctions;
import tech.aroma.thrift.message.service.MessageServiceConstants;
import tech.aroma.thrift.notification.service.NotificationService;
import tech.aroma.thrift.notification.service.SendNotificationRequest;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.operations.ThriftOperation;

final class SendMessageOperation
implements ThriftOperation<SendMessageRequest, SendMessageResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SendMessageOperation.class);
    private final AuthenticationService.Iface authenticationService;
    private final ApplicationRepository appRepo;
    private final InboxRepository inboxRepo;
    private final MessageRepository messageRepo;
    private final FollowerRepository followerRepo;
    private final UserRepository userRepo;
    private final NotificationService.Iface notificationService;

    @Inject
    SendMessageOperation(AuthenticationService.Iface authenticationService, ApplicationRepository appRepo, FollowerRepository followerRepo, InboxRepository inboxRepo, MessageRepository messageRepo, UserRepository userRepo, NotificationService.Iface notificationService) {
        Arguments.checkThat((Object)authenticationService, (Object[])new Object[]{appRepo, followerRepo, inboxRepo, messageRepo, userRepo, notificationService}).are(Assertions.notNull());
        this.authenticationService = authenticationService;
        this.appRepo = appRepo;
        this.messageRepo = messageRepo;
        this.followerRepo = followerRepo;
        this.inboxRepo = inboxRepo;
        this.userRepo = userRepo;
        this.notificationService = notificationService;
    }

    public SendMessageResponse process(SendMessageRequest request) throws TException {
        Arguments.checkThat((Object)request).throwing(InvalidArgumentException.class).usingMessage("request missing").is(Assertions.notNull());
        Arguments.checkThat((Object)request.applicationToken).throwing(InvalidTokenException.class).usingMessage("missing Application Token").is(Assertions.notNull());
        GetTokenInfoResponse tokenInfo = this.tryToGetTokenInfo(request.applicationToken);
        ApplicationToken appToken = (ApplicationToken)TokenFunctions.authTokenToAppTokenFunction().apply(tokenInfo.token);
        String applicationId = appToken.applicationId;
        this.checkAppId(applicationId);
        Message message = this.createMessageFrom(request, appToken);
        this.messageRepo.saveMessage(message, MessageServiceConstants.DEFAULT_MESSAGE_LIFETIME);
        LOG.debug("Message successfully stored in repository");
        this.storeInFollowerInboxes(message);
        SendNotificationRequest sendNotificationRequest = this.createNotificationRequestFor(message);
        this.tryToSendNotification(sendNotificationRequest);
        SendMessageResponse response = new SendMessageResponse().setMessageId(message.messageId);
        return response;
    }

    private GetTokenInfoResponse tryToGetTokenInfo(ApplicationToken applicationToken) throws InvalidTokenException, OperationFailedException {
        GetTokenInfoResponse tokenInfo;
        GetTokenInfoRequest getTokenInfoRequest = new GetTokenInfoRequest().setTokenId(applicationToken.tokenId).setTokenType(TokenType.APPLICATION);
        try {
            tokenInfo = this.authenticationService.getTokenInfo(getTokenInfoRequest);
        }
        catch (InvalidTokenException ex) {
            LOG.warn("Application Token is Invalid: [{}]", (Object)applicationToken, (Object)ex);
            throw ex;
        }
        catch (TException ex) {
            LOG.error("Failed to get info for Token [{}]", (Object)applicationToken, (Object)ex);
            throw new OperationFailedException("Could not get token info: " + ex.getMessage());
        }
        Arguments.checkThat((Object)tokenInfo, (Object[])new TBase[]{tokenInfo.token}).throwing(OperationFailedException.class).usingMessage("AuthenticationService Response is missing Token Info").are(Assertions.notNull());
        Arguments.checkThat((Object)tokenInfo.token.ownerId).throwing(OperationFailedException.class).usingMessage("missing Token Info").is(StringAssertions.nonEmptyString());
        return tokenInfo;
    }

    private Message createMessageFrom(SendMessageRequest request, ApplicationToken token) {
        UUID messageId = UUIDs.timeBased();
        Message message = new Message().setApplicationId(token.applicationId).setApplicationName(token.applicationName).setMessageId(messageId.toString()).setBody(request.body).setTitle(request.title).setUrgency(request.urgency).setTimeOfCreation(request.timeOfMessage).setTimeMessageReceived(Instant.now().toEpochMilli()).setHostname(request.hostname).setMacAddress(request.macAddress);
        return message;
    }

    private SendNotificationRequest createNotificationRequestFor(Message message) {
        ApplicationSentMessage applicationSentMessage = new ApplicationSentMessage().setApplicationId(message.applicationId).setApplicationName(message.applicationName).setMessage(message.body);
        EventType eventType = new EventType();
        eventType.setApplicationSentMessage(applicationSentMessage);
        Event event = new Event().setTimestamp(Instant.now().getEpochSecond()).setEventId("").setEventType(eventType);
        return new SendNotificationRequest().setEvent(event);
    }

    private void tryToSendNotification(SendNotificationRequest sendNotificationRequest) {
        try {
            this.notificationService.sendNotification(sendNotificationRequest);
        }
        catch (TException ex) {
            LOG.warn("Failed to send Notification request: {}", (Object)sendNotificationRequest, (Object)ex);
        }
    }

    private void checkAppId(String applicationId) throws OperationFailedException {
        Arguments.checkThat((Object)applicationId).throwing(OperationFailedException.class).usingMessage("Could not get Application ID from Token").is(StringAssertions.nonEmptyString()).is(StringAssertions.stringWithLengthGreaterThanOrEqualTo((int)10));
    }

    private void storeInFollowerInboxes(Message message) throws TException {
        String appId = message.applicationId;
        Set followers = Sets.toSet((Collection)this.followerRepo.getApplicationFollowers(appId));
        Set<User> owners = this.getOwnerForApp(appId);
        followers.addAll(owners);
        followers.parallelStream().forEach(user -> this.tryToSaveInInbox(message, (User)user));
        LOG.debug("Store Message in the Inboxes of {} users", (Object)followers.size());
    }

    private Set<User> getOwnerForApp(String appId) throws TException {
        Application app = this.appRepo.getById(appId);
        return app.owners.stream().map(this::toUser).collect(Collectors.toSet());
    }

    private void tryToSaveInInbox(Message message, User user) {
        LengthOfTime lifetime = new LengthOfTime(TimeUnit.HOURS, 12L);
        try {
            this.inboxRepo.saveMessageForUser(user, message, lifetime);
        }
        catch (TException ex) {
            LOG.error("Failed to save message {} in Inbox of User {}", new Object[]{message, user, ex});
        }
    }

    private User toUser(String userId) {
        try {
            return this.userRepo.getUser(userId);
        }
        catch (TException ex) {
            LOG.warn("Could not find user With ID [{}]", (Object)userId, (Object)ex);
            return new User().setUserId(userId);
        }
    }
}

