/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service;

import decorice.DecoratedBy;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.assertions.AuthenticationAssertions;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.aroma.thrift.application.service.SendMessageRequest;
import tech.aroma.thrift.application.service.SendMessageResponse;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.TokenType;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.GetTokenInfoRequest;
import tech.aroma.thrift.authentication.service.GetTokenInfoResponse;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidCredentialsException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
@DecoratorPattern(role=DecoratorPattern.Role.CONCRETE_DECORATOR)
final class AuthenticationLayer
implements ApplicationService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationLayer.class);
    private final AuthenticationService.Iface authenticationService;
    private final ApplicationService.Iface delegate;
    private final Function<AuthenticationToken, ApplicationToken> tokenMapper;

    @Inject
    AuthenticationLayer(AuthenticationService.Iface authenticationService, @DecoratedBy(value=AuthenticationLayer.class) ApplicationService.Iface delegate, Function<AuthenticationToken, ApplicationToken> tokenMapper) {
        Arguments.checkThat((Object)delegate, (Object[])new Object[]{authenticationService, tokenMapper}).are(Assertions.notNull());
        this.authenticationService = authenticationService;
        this.delegate = delegate;
        this.tokenMapper = tokenMapper;
    }

    public double getApiVersion() throws TException {
        return this.delegate.getApiVersion();
    }

    public SendMessageResponse sendMessage(SendMessageRequest request) throws OperationFailedException, InvalidArgumentException, InvalidCredentialsException, TException {
        Arguments.checkThat((Object)request).is(Assertions.notNull());
        this.checkTokenIsValid(request.applicationToken);
        if (!request.applicationToken.isSetApplicationId()) {
            ApplicationToken newToken = this.getAdditionalTokenInfo(request.applicationToken);
            request.setApplicationToken(newToken);
        }
        return this.delegate.sendMessage(request);
    }

    public void sendMessageAsync(SendMessageRequest request) throws TException {
        Arguments.checkThat((Object)request).is(Assertions.notNull());
        this.checkTokenIsValid(request.applicationToken);
        this.delegate.sendMessageAsync(request);
    }

    private ApplicationToken getAdditionalTokenInfo(ApplicationToken applicationToken) throws TException {
        GetTokenInfoRequest request = new GetTokenInfoRequest().setTokenId(applicationToken.tokenId).setTokenType(TokenType.APPLICATION);
        GetTokenInfoResponse response = this.tryToGetTokenInfo(request);
        Arguments.checkThat((Object)response).usingMessage("Auth Service returned null response").throwing(OperationFailedException.class).is(Assertions.notNull());
        Arguments.checkThat((Object)response.token).usingMessage("Auth Service returned incomplete token").throwing(OperationFailedException.class).is(AuthenticationAssertions.completeToken());
        ApplicationToken newAppToken = this.convertToAppToken(response.token);
        return newAppToken;
    }

    private GetTokenInfoResponse tryToGetTokenInfo(GetTokenInfoRequest request) throws OperationFailedException {
        try {
            return this.authenticationService.getTokenInfo(request);
        }
        catch (TException ex) {
            LOG.error("Failed to get Additional token info for: {}", (Object)request);
            throw new OperationFailedException("Could not get token infO: " + ex.getMessage());
        }
    }

    private ApplicationToken convertToAppToken(AuthenticationToken token) {
        return this.tokenMapper.apply(token);
    }

    private void checkTokenIsValid(ApplicationToken token) throws TException {
        Arguments.checkThat((Object)token).throwing(InvalidTokenException.class).usingMessage("Request missing token").is(Assertions.notNull());
        Arguments.checkThat((Object)token.tokenId).throwing(InvalidTokenException.class).usingMessage("Request missing tokenId").is(StringAssertions.nonEmptyString());
        VerifyTokenRequest request = new VerifyTokenRequest().setTokenId(token.tokenId).setOwnerId(token.applicationId);
        try {
            this.authenticationService.verifyToken(request);
        }
        catch (TException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("Authentication Service call failed", (Throwable)ex);
            throw new OperationFailedException("Could not reach Authentication Service: " + ex.getMessage());
        }
    }
}

