/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.application.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.authentication.service.VerifyTokenResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
@Internal
public final class ApplicationAssertions {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationAssertions.class);

    private ApplicationAssertions() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyAssertion<ApplicationToken> validTokenIn(@Required AuthenticationService.Iface authenticationService) {
        Arguments.checkThat((Object)authenticationService).usingMessage("authentication service is null").is(Assertions.notNull());
        return token -> {
            Arguments.checkThat((Object)token).usingMessage("token is null").is(Assertions.notNull());
            Arguments.checkThat((Object)token.tokenId).usingMessage("tokenId is missing").is(StringAssertions.nonEmptyString());
            VerifyTokenRequest request = new VerifyTokenRequest().setTokenId(token.getTokenId()).setOwnerId(token.applicationId);
            try {
                VerifyTokenResponse response = authenticationService.verifyToken(request);
            }
            catch (InvalidTokenException ex) {
                throw new FailedAssertionException("Token is not valid");
            }
            catch (Exception ex) {
                throw new FailedAssertionException("Could not contact Authentication Service", (Throwable)ex);
            }
        };
    }

    public static ExceptionMapper<InvalidArgumentException> withMessage(String message) {
        return ex -> new InvalidArgumentException(message);
    }
}

