/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class TimeGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(TimeGenerators.class);

    TimeGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyGenerator<Instant> presentInstants() {
        return Instant::now;
    }

    public static AlchemyGenerator<Instant> pastInstants() {
        return TimeGenerators.before(Instant.now());
    }

    public static AlchemyGenerator<Instant> futureInstants() {
        return () -> {
            Instant present = Instant.now();
            return TimeGenerators.after(present).get();
        };
    }

    public static AlchemyGenerator<Instant> before(@NonNull Instant instant) throws IllegalArgumentException {
        Checks.checkNotNull(instant, "instant cannot be null");
        return () -> {
            int daysBefore = AlchemyGenerator.one(NumberGenerators.integers(1, 1000));
            int hoursBefore = AlchemyGenerator.one(NumberGenerators.integers(0, 100));
            int minutesBefore = AlchemyGenerator.one(NumberGenerators.integers(0, 60));
            int secondsBefore = AlchemyGenerator.one(NumberGenerators.integers(0, 60));
            int millisecondsBefore = AlchemyGenerator.one(NumberGenerators.integers(0, 1000));
            return instant.minus(daysBefore, ChronoUnit.DAYS).minus(hoursBefore, ChronoUnit.HOURS).minus(minutesBefore, ChronoUnit.MINUTES).minus(secondsBefore, ChronoUnit.SECONDS).minus(millisecondsBefore, ChronoUnit.MILLIS);
        };
    }

    public static AlchemyGenerator<Instant> after(@NonNull Instant instant) throws IllegalArgumentException {
        Checks.checkNotNull(instant, "instant cannot be null");
        return () -> {
            int daysAhead = AlchemyGenerator.one(NumberGenerators.integers(1, 11000));
            int hoursAhead = AlchemyGenerator.one(NumberGenerators.integers(0, 100));
            int minutesAhead = AlchemyGenerator.one(NumberGenerators.integers(0, 60));
            int secondsAhead = AlchemyGenerator.one(NumberGenerators.integers(0, 60));
            int millisecondsAhead = AlchemyGenerator.one(NumberGenerators.integers(0, 1000));
            return instant.plus((long)daysAhead, ChronoUnit.DAYS).plus((long)hoursAhead, ChronoUnit.HOURS).plus((long)minutesAhead, ChronoUnit.MINUTES).plus((long)secondsAhead, ChronoUnit.SECONDS).plus((long)millisecondsAhead, ChronoUnit.MILLIS);
        };
    }

    public static AlchemyGenerator<Instant> anytime() {
        return () -> {
            int choice = AlchemyGenerator.one(NumberGenerators.integers(0, 3));
            switch (choice) {
                case 0: {
                    return TimeGenerators.pastInstants().get();
                }
                case 1: {
                    return TimeGenerators.futureInstants().get();
                }
            }
            return TimeGenerators.presentInstants().get();
        };
    }

    public static AlchemyGenerator<Instant> timesBetween(@NonNull Instant startTime, @NonNull Instant endTime) throws IllegalArgumentException {
        Checks.checkNotNull(startTime, "startTime is null");
        Checks.checkNotNull(endTime, "endTime is null");
        Checks.checkThat(startTime.isBefore(endTime), "startTime must be before endTime");
        long epochOfStart = startTime.toEpochMilli();
        long epochOfEnd = endTime.toEpochMilli();
        AlchemyGenerator<Long> timestampGenerator = NumberGenerators.longs(epochOfStart, epochOfEnd);
        return () -> {
            long timestamp = (Long)timestampGenerator.get();
            return Instant.ofEpochMilli(timestamp);
        };
    }
}

