/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BinaryGenerators;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.DateGenerators;
import tech.sirwellington.alchemy.generator.NetworkGenerators;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;
import tech.sirwellington.alchemy.generator.TimeGenerators;

@NonInstantiable
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class ObjectGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectGenerators.class);
    private static final Map<Class<?>, AlchemyGenerator<?>> DEFAULT_GENERATOR_MAPPINGS = new ConcurrentHashMap();

    ObjectGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static <T> AlchemyGenerator<T> pojos(Class<T> classOfPojo) {
        return ObjectGenerators.pojos(classOfPojo, DEFAULT_GENERATOR_MAPPINGS);
    }

    public static <T> AlchemyGenerator<T> pojos(Class<T> classOfPojo, Map<Class<?>, AlchemyGenerator<?>> customMappings) {
        Checks.checkNotNull(classOfPojo, "missing class of POJO");
        Checks.checkThat(ObjectGenerators.canInstantiate(classOfPojo), "cannot instantiate class: " + classOfPojo);
        Checks.checkThat(!ObjectGenerators.isPrimitiveClass(classOfPojo), "Cannot use pojos with Primitive Type. Use one of the Primitive generators instead.");
        List validFields = Arrays.asList(classOfPojo.getDeclaredFields()).stream().filter(f -> !ObjectGenerators.isStatic(f)).filter(f -> !ObjectGenerators.isFinal(f)).collect(Collectors.toList());
        return () -> {
            Object instance;
            try {
                instance = ObjectGenerators.instantiate(classOfPojo);
            }
            catch (Exception ex) {
                LOG.error("Failed to instantiate {}", (Object)classOfPojo.getName(), (Object)ex);
                return null;
            }
            for (Field field : validFields) {
                ObjectGenerators.tryInjectField(instance, field, customMappings);
            }
            return instance;
        };
    }

    private static <T> boolean canInstantiate(Class<T> classOfPojo) {
        try {
            ObjectGenerators.instantiate(classOfPojo);
            return true;
        }
        catch (Exception ex) {
            LOG.warn("cannot instatiate type {}", classOfPojo);
            return false;
        }
    }

    private static boolean isStatic(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private static boolean isFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T instantiate(Class<T> classOfT) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<T> defaultConstructor = classOfT.getDeclaredConstructor(new Class[0]);
        boolean originalAccessibility = defaultConstructor.isAccessible();
        try {
            defaultConstructor.setAccessible(true);
            T t = defaultConstructor.newInstance(new Object[0]);
            return t;
        }
        finally {
            defaultConstructor.setAccessible(originalAccessibility);
        }
    }

    private static <T> boolean isPrimitiveClass(Class<T> classOfPojo) {
        if (classOfPojo.isPrimitive()) {
            return true;
        }
        HashSet<Class<Instant>> otherPrimitives = new HashSet<Class<Instant>>();
        otherPrimitives.add(String.class);
        otherPrimitives.add(Date.class);
        otherPrimitives.add(Instant.class);
        return otherPrimitives.contains(classOfPojo);
    }

    private static <T> void tryInjectField(T instance, Field field, Map<Class<?>, AlchemyGenerator<?>> generatorMappings) {
        try {
            ObjectGenerators.injectField(instance, field, generatorMappings);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.warn("Could not inject field {}", (Object)field.toString(), (Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectField(Object pojo, Field field, Map<Class<?>, AlchemyGenerator<?>> generatorMappings) throws IllegalArgumentException, IllegalAccessException {
        Class typeOfField = field.getType();
        AlchemyGenerator<?> generator = ObjectGenerators.determineGeneratorFor(typeOfField = ClassUtils.primitiveToWrapper(typeOfField), field, generatorMappings);
        if (generator == null) {
            LOG.warn("Could not find a suitable AlchemyGenerator for field {} with type {}", (Object)field, (Object)typeOfField);
            return;
        }
        Object value = generator.get();
        boolean originalAccessibility = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(pojo, value);
        }
        finally {
            field.setAccessible(originalAccessibility);
        }
    }

    private static AlchemyGenerator<?> determineGeneratorFor(Class<?> typeOfField, Field field, Map<Class<?>, AlchemyGenerator<?>> generatorMappings) {
        AlchemyGenerator<Object> generator = generatorMappings.get(typeOfField);
        if (generator != null) {
            return generator;
        }
        if (ObjectGenerators.isCollectionType(typeOfField)) {
            if (ObjectGenerators.lacksGenericTypeArguments(field)) {
                LOG.warn("POJO {} contains a Collection field {} which is not type-parametrized. Cannot inject.", field.getDeclaringClass(), (Object)field);
                return null;
            }
            generator = ObjectGenerators.determineGeneratorForCollectionField(field, typeOfField, generatorMappings);
        } else if (ObjectGenerators.isEnumType(typeOfField)) {
            Object[] enumValues = typeOfField.getEnumConstants();
            if (enumValues == null) {
                LOG.warn("Enum Class {} has no Enum Values: " + typeOfField);
                return null;
            }
            generator = () -> {
                int position = AlchemyGenerator.one(NumberGenerators.integers(0, enumValues.length));
                return enumValues[position];
            };
        } else {
            generator = ObjectGenerators.pojos(typeOfField);
        }
        return generator;
    }

    private static boolean isCollectionType(Class<?> type) {
        return ObjectGenerators.isListType(type) || ObjectGenerators.isSetType(type) || ObjectGenerators.isMapType(type);
    }

    private static boolean isListType(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    private static boolean isSetType(Class<?> type) {
        return Set.class.isAssignableFrom(type);
    }

    private static boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    private static boolean lacksGenericTypeArguments(Field field) {
        Type genericType = field.getGenericType();
        return !(genericType instanceof ParameterizedType);
    }

    private static AlchemyGenerator<?> determineGeneratorForCollectionField(Field collectionField, Class<?> collectionType, Map<Class<?>, AlchemyGenerator<?>> generatorMappings) {
        if (ObjectGenerators.isMapType(collectionType)) {
            return ObjectGenerators.determineGeneratorForMapField(collectionField, collectionType, generatorMappings);
        }
        ParameterizedType parameterizedType = (ParameterizedType)collectionField.getGenericType();
        Class valueType = (Class)parameterizedType.getActualTypeArguments()[0];
        AlchemyGenerator<?> generator = generatorMappings.getOrDefault(valueType, ObjectGenerators.determineGeneratorFor(valueType, collectionField, generatorMappings));
        ArrayList list = new ArrayList();
        int size = AlchemyGenerator.one(NumberGenerators.integers(10, 100));
        for (int i = 0; i < size; ++i) {
            list.add(generator.get());
        }
        if (Set.class.isAssignableFrom(collectionType)) {
            HashSet set = new HashSet(list);
            return () -> set;
        }
        return () -> list;
    }

    private static AlchemyGenerator<?> determineGeneratorForMapField(Field mapField, Class<?> mapType, Map<Class<?>, AlchemyGenerator<?>> generatorMappings) {
        ParameterizedType parameterizedType = (ParameterizedType)mapField.getGenericType();
        Class keyType = (Class)parameterizedType.getActualTypeArguments()[0];
        Class valueType = (Class)parameterizedType.getActualTypeArguments()[1];
        AlchemyGenerator<?> keyGenerator = generatorMappings.getOrDefault(keyType, ObjectGenerators.determineGeneratorFor(keyType, mapField, generatorMappings));
        AlchemyGenerator<?> valueGenerator = generatorMappings.getOrDefault(valueType, ObjectGenerators.determineGeneratorFor(valueType, mapField, generatorMappings));
        HashMap map = new HashMap();
        int size = AlchemyGenerator.one(NumberGenerators.integers(10, 100));
        for (int i = 0; i < size; ++i) {
            map.put(keyGenerator.get(), valueGenerator.get());
        }
        return () -> map;
    }

    private static boolean isEnumType(Class<?> typeOfField) {
        return typeOfField.isEnum();
    }

    static {
        DEFAULT_GENERATOR_MAPPINGS.put(String.class, StringGenerators.alphabeticString());
        DEFAULT_GENERATOR_MAPPINGS.put(Integer.class, NumberGenerators.smallPositiveIntegers());
        DEFAULT_GENERATOR_MAPPINGS.put(Long.class, NumberGenerators.positiveLongs());
        DEFAULT_GENERATOR_MAPPINGS.put(Double.class, NumberGenerators.positiveDoubles());
        DEFAULT_GENERATOR_MAPPINGS.put(Date.class, DateGenerators.anyTime());
        DEFAULT_GENERATOR_MAPPINGS.put(Instant.class, TimeGenerators.anytime());
        DEFAULT_GENERATOR_MAPPINGS.put(ByteBuffer.class, BinaryGenerators.byteBuffers(333));
        DEFAULT_GENERATOR_MAPPINGS.put(Boolean.class, BooleanGenerators.booleans());
        DEFAULT_GENERATOR_MAPPINGS.put(Byte.class, BinaryGenerators.bytes());
        DEFAULT_GENERATOR_MAPPINGS.put(URL.class, NetworkGenerators.httpUrls());
    }
}

