/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.PeopleGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
public final class NetworkGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkGenerators.class);
    private static final URL FALLBACK_URL;
    private static final List<String> VALID_PROTOCOLS;

    private NetworkGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyGenerator<URL> httpUrls() {
        return NetworkGenerators.urlsWithProtocol("http");
    }

    public static AlchemyGenerator<URL> httpsUrls() {
        return NetworkGenerators.urlsWithProtocol("https");
    }

    public static AlchemyGenerator<URL> urlsWithProtocol(@NonEmpty String protocol) {
        Checks.checkNotEmpty(protocol, "missing protocol");
        String cleanProtocol = protocol.replace("://", "");
        try {
            new URL(cleanProtocol + "://");
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Unknown protocol: " + protocol, ex);
        }
        return () -> {
            String url = String.format("%s://%s%s", cleanProtocol, AlchemyGenerator.one(StringGenerators.alphanumericString()), AlchemyGenerator.one(PeopleGenerators.popularEmailDomains()));
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                LOG.error("Failed to create url from scheme {}", (Object)cleanProtocol, (Object)ex);
                return FALLBACK_URL;
            }
        };
    }

    public static AlchemyGenerator<Integer> ports() {
        return NumberGenerators.integers(22, Short.MAX_VALUE);
    }

    static {
        try {
            FALLBACK_URL = new URL("http://google.com");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Could not generate URL", ex);
        }
        VALID_PROTOCOLS = Arrays.asList("http", "https", "ftp", "file", "ssh");
    }
}

