/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.performance;

import com.google.common.base.Strings;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.performance.Operation;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
@Internal
final class Operations {
    private static final Logger LOG = LoggerFactory.getLogger(Operations.class);

    Operations() {
    }

    public static long measureOperation(@Required Operation<?> operation) throws TException {
        Arguments.checkThat(operation).is(Assertions.notNull());
        long start = System.currentTimeMillis();
        operation.call();
        long end = System.currentTimeMillis();
        return end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T logLatency(@Required Operation<T> operation, String operationName) throws TException {
        Arguments.checkThat(operation).is(Assertions.notNull());
        operationName = Strings.nullToEmpty((String)operationName);
        long start = System.currentTimeMillis();
        try {
            T t = operation.call();
            return t;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("{} Operation took {} ms", (Object)operationName, (Object)(end - start));
        }
    }
}

