/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.performance;

import decorice.DecoratedBy;
import java.util.List;
import javax.inject.Inject;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.UserRepository;
import tech.aroma.data.performance.Operation;
import tech.aroma.data.performance.Operations;
import tech.aroma.thrift.User;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@DecoratorPattern(role=DecoratorPattern.Role.DECORATOR)
public final class MeasuredUserRepository
implements UserRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MeasuredUserRepository.class);
    private final UserRepository delegate;

    @Inject
    public MeasuredUserRepository(@DecoratedBy(value=MeasuredUserRepository.class) UserRepository delegate) {
        Arguments.checkThat((Object)delegate).is(Assertions.notNull());
        this.delegate = delegate;
    }

    @Override
    public void saveUser(User user) throws TException {
        Operation.VoidOperation operation = () -> this.delegate.saveUser(user);
        Operations.logLatency(operation, "saveUser");
    }

    @Override
    public User getUser(String userId) throws TException {
        Operation<User> operation = () -> this.delegate.getUser(userId);
        return Operations.logLatency(operation, "getUser");
    }

    @Override
    public void deleteUser(String userId) throws TException {
        Operation.VoidOperation operation = () -> this.delegate.deleteUser(userId);
        Operations.logLatency(operation, "deleteUser");
    }

    @Override
    public boolean containsUser(String userId) throws TException {
        Operation<Boolean> operation = () -> this.delegate.containsUser(userId);
        return Operations.logLatency(operation, "containsUser");
    }

    @Override
    public User getUserByEmail(String emailAddress) throws TException {
        Operation<User> operation = () -> this.delegate.getUserByEmail(emailAddress);
        return Operations.logLatency(operation, "getUserByEmail");
    }

    @Override
    public User findByGithubProfile(String githubProfile) throws TException {
        Operation<User> operation = () -> this.delegate.findByGithubProfile(githubProfile);
        return Operations.logLatency(operation, "findByGithubProfile");
    }

    @Override
    public List<User> getRecentlyCreatedUsers() throws TException {
        Operation<List> opeartion = () -> this.delegate.getRecentlyCreatedUsers();
        return Operations.logLatency(opeartion, "getRecentlyCreatedUsers");
    }
}

