/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.UserRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.UserDoesNotExistException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

final class MemoryUserRepository
implements UserRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryUserRepository.class);
    private final Map<String, User> users = Maps.createSynchronized();
    private final Map<String, String> usersByEmail = Maps.createSynchronized();
    private final Map<String, String> usersByGithubProfile = Maps.createSynchronized();

    MemoryUserRepository() {
    }

    @Override
    public void saveUser(User user) throws TException {
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).is(RequestAssertions.validUser());
        String userId = user.userId;
        String email = user.email;
        String githubProfile = user.githubProfile;
        this.users.put(userId, user);
        if (!RequestAssertions.isNullOrEmpty(email)) {
            this.usersByEmail.put(email, userId);
        }
        if (!RequestAssertions.isNullOrEmpty(githubProfile)) {
            this.usersByGithubProfile.put(githubProfile, userId);
        }
    }

    @Override
    public User getUser(String userId) throws TException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(UserDoesNotExistException.class).usingMessage(userId).is(CollectionAssertions.keyInMap(this.users));
        return this.users.get(userId);
    }

    @Override
    public void deleteUser(String userId) throws TException {
        String githubProfile;
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(UserDoesNotExistException.class).is(CollectionAssertions.keyInMap(this.users));
        User removedUser = this.users.remove(userId);
        String email = removedUser.email;
        if (!RequestAssertions.isNullOrEmpty(email)) {
            this.usersByEmail.remove(email);
        }
        if (!RequestAssertions.isNullOrEmpty(githubProfile = removedUser.githubProfile)) {
            this.usersByGithubProfile.remove(githubProfile);
        }
    }

    @Override
    public boolean containsUser(String userId) throws TException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        return this.users.containsKey(userId);
    }

    @Override
    public User getUserByEmail(String emailAddress) throws TException {
        Arguments.checkThat((Object)emailAddress).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(UserDoesNotExistException.class).usingMessage("Could not find email: " + emailAddress).is(CollectionAssertions.keyInMap(this.usersByEmail));
        String userId = this.usersByEmail.get(emailAddress);
        return this.users.get(userId);
    }

    @Override
    public User findByGithubProfile(String githubProfile) throws TException {
        Arguments.checkThat((Object)githubProfile).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(UserDoesNotExistException.class).is(CollectionAssertions.keyInMap(this.usersByGithubProfile));
        String userId = this.usersByGithubProfile.get(githubProfile);
        return this.users.get(userId);
    }

    @Override
    public List<User> getRecentlyCreatedUsers() throws TException {
        return Lists.copy(this.users.values());
    }
}

