/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationListener;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.data.TokenRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.assertions.AromaAssertions;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.arguments.assertions.TimeAssertions;

@ThreadSafe
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
final class MemoryTokenRepository
implements TokenRepository,
ExpirationListener<String, AuthenticationToken> {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryTokenRepository.class);
    private final ExpiringMap<String, AuthenticationToken> tokens = ExpiringMap.builder().variableExpiration().expirationListener((ExpirationListener)this).build();
    private final Map<String, List<AuthenticationToken>> tokensByOwner = ExpiringMap.builder().variableExpiration().build();

    MemoryTokenRepository() {
    }

    @Override
    public boolean containsToken(String tokenId) throws TException {
        Arguments.checkThat((Object)tokenId).throwing(InvalidArgumentException.class).usingMessage("missing tokenId").is(StringAssertions.nonEmptyString());
        return this.tokens.containsKey((Object)tokenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationToken getToken(String tokenId) throws TException, InvalidTokenException {
        Arguments.checkThat((Object)tokenId).throwing(InvalidArgumentException.class).usingMessage("missing tokenId").is(StringAssertions.nonEmptyString()).throwing(InvalidTokenException.class).usingMessage("token does not exists").is(CollectionAssertions.keyInMap(this.tokens));
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            return (AuthenticationToken)this.tokens.get((Object)tokenId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToken(AuthenticationToken token) throws TException {
        Arguments.checkThat((Object)token).usingMessage("attempting to save null token").throwing(InvalidArgumentException.class).is(AromaAssertions.legalToken());
        Arguments.checkThat((Object)token.ownerId).usingMessage("token missing ownerId").throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)token.tokenType).usingMessage("tokenType is required").throwing(InvalidArgumentException.class).is(Assertions.notNull());
        Instant expirationTime = Instant.ofEpochMilli(token.timeOfExpiration);
        Arguments.checkThat((Object)expirationTime).throwing(InvalidArgumentException.class).usingMessage("Token expiration time must be in the future: " + expirationTime).is(TimeAssertions.inTheFuture());
        Instant now = Instant.now();
        long timeToLiveSeconds = now.until(expirationTime, ChronoUnit.SECONDS);
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            this.tokens.put((Object)token.tokenId, (Object)token, timeToLiveSeconds, TimeUnit.SECONDS);
            this.addTokenForOwner(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthenticationToken> getTokensBelongingTo(String ownerId) throws TException {
        Arguments.checkThat((Object)ownerId).throwing(InvalidArgumentException.class).usingMessage("ownerId missing").is(StringAssertions.nonEmptyString());
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            return this.tokensByOwner.getOrDefault(ownerId, Lists.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteToken(String tokenId) throws TException {
        Arguments.checkThat((Object)tokenId).usingMessage("missing tokenId").throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            AuthenticationToken token = (AuthenticationToken)this.tokens.remove((Object)tokenId);
            if (token == null) {
                return;
            }
            this.deleteTokenFromOwner(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expired(String key, AuthenticationToken value) {
        String ownerId = value.ownerId;
        if (RequestAssertions.isNullOrEmpty(ownerId)) {
            return;
        }
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            this.deleteTokenFromOwner(value);
            List<AuthenticationToken> ownerTokens = this.tokensByOwner.getOrDefault(value.ownerId, Lists.emptyList());
            if (!Lists.isEmpty(ownerTokens)) {
                this.tokensByOwner.remove(ownerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTokenForOwner(AuthenticationToken token) {
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            List<AuthenticationToken> ownerTokens = this.tokensByOwner.getOrDefault(token.ownerId, Lists.create());
            ownerTokens.add(token);
            this.tokensByOwner.put(token.ownerId, ownerTokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTokenFromOwner(AuthenticationToken token) {
        String ownerId = token.ownerId;
        ExpiringMap<String, AuthenticationToken> expiringMap = this.tokens;
        synchronized (expiringMap) {
            List<Object> ownerTokens = this.tokensByOwner.getOrDefault(ownerId, Lists.emptyList());
            ownerTokens = ownerTokens.stream().filter(t -> !Objects.equals(t.tokenId, token.tokenId)).collect(Collectors.toList());
            this.tokensByOwner.put(ownerId, ownerTokens);
        }
    }
}

