/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationListener;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.MessageDoesNotExistException;
import tech.aroma.thrift.functions.TimeFunctions;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
final class MemoryMessageRepository
implements MessageRepository,
ExpirationListener<String, Message> {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMessageRepository.class);
    private final ExpiringMap<String, Message> messages = ExpiringMap.builder().variableExpiration().expirationListener((ExpirationListener)this).build();
    private final ExpiringMap<String, Set<String>> messagesByApplication = ExpiringMap.builder().variableExpiration().build();

    MemoryMessageRepository() {
    }

    @Override
    public void saveMessage(Message message, LengthOfTime lifetime) throws TException {
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).is(RequestAssertions.validMessage());
        Arguments.checkThat((Object)lifetime).usingMessage("lifetime cannot be missing").throwing(InvalidArgumentException.class).is(Assertions.notNull());
        long seconds = TimeFunctions.toSeconds((LengthOfTime)lifetime);
        String msgId = message.messageId;
        this.messages.put((Object)msgId, (Object)message, seconds, TimeUnit.SECONDS);
        String appId = message.applicationId;
        Set existing = (Set)this.messagesByApplication.getOrDefault((Object)appId, (Object)Sets.create());
        existing.add(msgId);
        this.messagesByApplication.put((Object)appId, (Object)existing);
    }

    @Override
    public Message getMessage(String applicationId, String messageId) throws TException {
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)messageId).throwing(MessageDoesNotExistException.class).is(CollectionAssertions.keyInMap(this.messages));
        Message message = (Message)this.messages.get((Object)messageId);
        Arguments.checkThat((Object)message.applicationId).throwing(MessageDoesNotExistException.class).usingMessage("Message does not correspond to the given App ID").is(Assertions.equalTo((Object)applicationId));
        return message;
    }

    @Override
    public void deleteMessage(String applicationId, String messageId) throws TException {
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.nonEmptyString());
        if (!this.messages.containsKey((Object)messageId)) {
            return;
        }
        Message message = (Message)this.messages.remove((Object)messageId);
        String appId = message.applicationId;
        Set appMessages = (Set)this.messagesByApplication.getOrDefault((Object)appId, (Object)Sets.create());
        appMessages.remove(messageId);
        this.messagesByApplication.put((Object)appId, (Object)appMessages);
    }

    @Override
    public boolean containsMessage(String applicationId, String messageId) throws TException {
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.nonEmptyString());
        return this.messages.containsKey((Object)messageId);
    }

    @Override
    public List<Message> getByHostname(String hostname) throws TException {
        Arguments.checkThat((Object)hostname).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        return this.messages.values().stream().filter(m -> Objects.equals(m.hostname, hostname)).collect(Collectors.toList());
    }

    @Override
    public List<Message> getByApplication(String applicationId) throws TException {
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).is(RequestAssertions.validApplicationId());
        return ((Set)this.messagesByApplication.getOrDefault((Object)applicationId, (Object)Sets.emptySet())).stream().map(id -> (Message)this.messages.get(id)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<Message> getByTitle(String applicationId, String title) throws TException {
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).is(RequestAssertions.validApplicationId());
        Arguments.checkThat((Object)title).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        return ((Set)this.messagesByApplication.getOrDefault((Object)applicationId, (Object)Sets.emptySet())).stream().map(id -> (Message)this.messages.get(id)).filter(Objects::nonNull).filter(m -> Objects.equals(m.title, title)).collect(Collectors.toList());
    }

    @Override
    public long getCountByApplication(String applicationId) throws TException {
        return ((Set)this.messagesByApplication.getOrDefault((Object)applicationId, (Object)Sets.emptySet())).size();
    }

    public void expired(String key, Message value) {
        if (RequestAssertions.isNullOrEmpty(key)) {
            return;
        }
        if (Objects.isNull(value)) {
            return;
        }
        String appId = value.applicationId;
        Set appMessages = (Set)this.messagesByApplication.getOrDefault((Object)appId, (Object)Sets.create());
        appMessages.remove(key);
        this.messagesByApplication.put((Object)appId, (Object)appMessages);
    }
}

