/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

final class MemoryInboxRepository
implements InboxRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryInboxRepository.class);
    private final Map<String, List<Message>> messagesForUser = Maps.createSynchronized();

    MemoryInboxRepository() {
    }

    @Override
    public void saveMessageForUser(@Required User user, @Required Message message, @Required LengthOfTime lifetime) throws TException {
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).is(RequestAssertions.validMessage());
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).is(RequestAssertions.validUser());
        String userId = user.userId;
        List<Message> messages = this.messagesForUser.getOrDefault(userId, Lists.create());
        messages.add(message);
        this.messagesForUser.put(userId, messages);
    }

    @Override
    public List<Message> getMessagesForUser(String userId) throws TException {
        this.checkUserId(userId);
        return this.messagesForUser.getOrDefault(userId, Lists.emptyList());
    }

    @Override
    public void deleteMessageForUser(String userId, String messageId) throws TException {
        Arguments.checkThat((Object)userId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).usingMessage("empty arguments").are(StringAssertions.nonEmptyString());
        Predicate<Message> notEqualToMessageId = msg -> !Objects.equal((Object)msg.messageId, (Object)messageId);
        List<Object> messages = this.messagesForUser.getOrDefault(userId, Lists.emptyList());
        messages = messages.stream().filter(notEqualToMessageId).collect(Collectors.toList());
        this.messagesForUser.put(userId, messages);
    }

    @Override
    public void deleteAllMessagesForUser(String userId) throws TException {
        this.checkUserId(userId);
        this.messagesForUser.remove(userId);
    }

    @Override
    public long countInboxForUser(String userId) throws TException {
        this.checkUserId(userId);
        return this.messagesForUser.getOrDefault(userId, Lists.emptyList()).size();
    }

    @Override
    public boolean containsMessageInInbox(String userId, Message message) throws TException {
        this.checkUserId(userId);
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).is(RequestAssertions.validMessage());
        String messageId = message.messageId;
        return this.messagesForUser.getOrDefault(userId, Lists.emptyList()).stream().map(Message::getMessageId).anyMatch(id -> Objects.equal((Object)id, (Object)messageId));
    }

    private void checkUserId(String userId) throws InvalidArgumentException {
        Arguments.checkThat((Object)userId).usingMessage("missing userId").throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
    }
}

