/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.Row;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.data.CredentialRepository;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.MediaRepository;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.OrganizationRepository;
import tech.aroma.data.TokenRepository;
import tech.aroma.data.UserRepository;
import tech.aroma.data.cassandra.CassandraApplicationRepository;
import tech.aroma.data.cassandra.CassandraCredentialsRepository;
import tech.aroma.data.cassandra.CassandraFollowerRepository;
import tech.aroma.data.cassandra.CassandraInboxRepository;
import tech.aroma.data.cassandra.CassandraMediaRepository;
import tech.aroma.data.cassandra.CassandraMessageRepository;
import tech.aroma.data.cassandra.CassandraOrganizationRepository;
import tech.aroma.data.cassandra.CassandraTokenRepository;
import tech.aroma.data.cassandra.CassandraUserRepository;
import tech.aroma.data.cassandra.Mappers;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.User;
import tech.aroma.thrift.authentication.AuthenticationToken;

public final class ModuleCassandraDataRepositories
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleCassandraDataRepositories.class);

    protected void configure() {
        this.bind(ApplicationRepository.class).to(CassandraApplicationRepository.class).asEagerSingleton();
        this.bind(CredentialRepository.class).to(CassandraCredentialsRepository.class).asEagerSingleton();
        this.bind(FollowerRepository.class).to(CassandraFollowerRepository.class).asEagerSingleton();
        this.bind(InboxRepository.class).to(CassandraInboxRepository.class).asEagerSingleton();
        this.bind(MediaRepository.class).to(CassandraMediaRepository.class).asEagerSingleton();
        this.bind(MessageRepository.class).to(CassandraMessageRepository.class).asEagerSingleton();
        this.bind(OrganizationRepository.class).to(CassandraOrganizationRepository.class).asEagerSingleton();
        this.bind(TokenRepository.class).to(CassandraTokenRepository.class).asEagerSingleton();
        this.bind(UserRepository.class).to(CassandraUserRepository.class).asEagerSingleton();
    }

    @Provides
    Function<Row, Application> provideApplicationMapper() {
        return Mappers.appMapper();
    }

    @Provides
    Function<Row, Image> provideImageMapper() {
        return Mappers.imageMapper();
    }

    @Provides
    Function<Row, Message> provideMessageMapper() {
        return Mappers.messageMapper();
    }

    @Provides
    Function<Row, Organization> provideOrganizationMapper() {
        return Mappers.orgMapper();
    }

    @Provides
    Function<Row, AuthenticationToken> provideTokenMapper() {
        return Mappers.tokenMapper();
    }

    @Provides
    Function<Row, User> provideUserMapper() {
        return Mappers.userMapper();
    }
}

