/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.cassandra;

import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.ImageType;
import tech.aroma.thrift.Industry;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.ProgrammingLanguage;
import tech.aroma.thrift.Role;
import tech.aroma.thrift.Tier;
import tech.aroma.thrift.Urgency;
import tech.aroma.thrift.User;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.TokenType;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;

@NonInstantiable
@Internal
final class Mappers {
    private static final Logger LOG = LoggerFactory.getLogger(Mappers.class);

    Mappers() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    static Function<Row, Application> appMapper() {
        return row -> {
            Date tokenExpiration;
            Date timeOfProvisioning;
            String programmingLanguage;
            Application app = new Application();
            UUID appId = row.getUUID("app_id");
            if (appId != null) {
                app.setApplicationId(appId.toString());
            }
            if (!RequestAssertions.isNullOrEmpty(programmingLanguage = row.getString("programming_language"))) {
                ProgrammingLanguage language = ProgrammingLanguage.valueOf((String)programmingLanguage);
                app.setProgrammingLanguage(language);
            }
            if ((timeOfProvisioning = row.getTimestamp("time_provisioned")) != null) {
                app.setTimeOfProvisioning(timeOfProvisioning.getTime());
            }
            if (Mappers.doesRowContainColumn(row, "time_of_token_expiration") && (tokenExpiration = row.getTimestamp("time_of_token_expiration")) != null) {
                app.setTimeOfTokenExpiration(tokenExpiration.getTime());
            }
            Set owners = row.getSet("owners", UUID.class).stream().map(UUID::toString).collect(Collectors.toSet());
            app.setOwners(owners);
            UUID orgId = row.getUUID("organization_id");
            if (orgId != null) {
                app.setOrganizationId(orgId.toString());
            }
            app.setName(row.getString("name")).setApplicationDescription(row.getString("app_description")).setTier((Tier)row.get("tier", Tier.class));
            return app;
        };
    }

    static Function<Row, Image> imageMapper() {
        return row -> {
            Image image = new Image();
            ByteBuffer binary = row.getBytes("binary");
            image.setData(binary);
            int width = row.getInt("width");
            int height = row.getInt("height");
            image.setDimension(new Dimension(width, height));
            String mediaType = row.getString("media_type");
            try {
                image.setImageType(ImageType.valueOf((String)mediaType));
            }
            catch (Exception ex) {
                LOG.warn("Could not find ImageType: {}", (Object)mediaType, (Object)ex);
            }
            return image;
        };
    }

    static Function<Row, Message> messageMapper() {
        return row -> {
            String urgency;
            Message message = new Message();
            UUID msgId = row.getUUID("message_id");
            UUID appId = row.getUUID("app_id");
            message.setMessageId(msgId.toString()).setApplicationId(appId.toString()).setTitle(row.getString("title")).setHostname(row.getString("hostname")).setMacAddress(row.getString("mac_address")).setBody(row.getString("body")).setApplicationName(row.getString("app_name"));
            Date timeCreated = row.getTimestamp("time_created");
            Date timeReceived = row.getTimestamp("time_received");
            if (timeCreated != null) {
                message.setTimeOfCreation(timeCreated.getTime());
            }
            if (timeReceived != null) {
                message.setTimeMessageReceived(timeReceived.getTime());
            }
            if (!RequestAssertions.isNullOrEmpty(urgency = row.getString("urgency"))) {
                message.setUrgency(Urgency.valueOf((String)urgency));
            }
            return message;
        };
    }

    static Function<Row, Organization> orgMapper() {
        return row -> {
            Organization org = new Organization();
            UUID orgUuid = row.getUUID("org_id");
            List owners = Lists.create();
            if (Mappers.doesRowContainColumn(row, "owners")) {
                Set ownerIds = row.getSet("owners", UUID.class);
                owners = ownerIds.stream().map(UUID::toString).collect(Collectors.toList());
            }
            org.setOrganizationId(orgUuid.toString()).setOrganizationName(row.getString("org_name")).setLogoLink(row.getString("icon_link")).setOrganizationDescription(row.getString("description")).setIndustry((Industry)row.get("industry", Industry.class)).setGithubProfile(row.getString("github_profile")).setOrganizationEmail(row.getString("contact_email")).setStockMarketSymbol(row.getString("stock_name")).setTier((Tier)row.get("tier", Tier.class)).setWebsite(row.getString("website")).setOwners(owners);
            return org;
        };
    }

    static Function<Row, AuthenticationToken> tokenMapper() {
        return row -> {
            AuthenticationToken token = new AuthenticationToken();
            Date timeOfCreation = row.getTimestamp("time_of_creation");
            Date timeOfExpiration = row.getTimestamp("time_of_expiration");
            if (timeOfCreation != null) {
                token.setTimeOfCreation(timeOfCreation.getTime());
            }
            if (timeOfExpiration != null) {
                token.setTimeOfExpiration(timeOfExpiration.getTime());
            }
            String orgId = null;
            if (Mappers.doesRowContainColumn(row, "organization_id")) {
                UUID orgUuid = row.getUUID("organization_id");
                orgId = orgUuid != null ? orgUuid.toString() : orgId;
            }
            token.setTokenId(row.getUUID("token_id").toString()).setOwnerId(row.getUUID("owner_id").toString()).setOrganizationId(orgId).setOwnerName(row.getString("owner_name")).setTokenType((TokenType)row.get("token_type", TokenType.class));
            return token;
        };
    }

    static Function<Row, User> userMapper() {
        return row -> {
            Date timeCreated;
            Date birthDate;
            User user = new User();
            String email = null;
            if (Mappers.doesRowContainColumn(row, "email")) {
                email = row.getString("email");
            } else if (Mappers.doesRowContainColumn(row, "emails")) {
                Set emails = row.getSet("emails", String.class);
                email = emails.stream().findFirst().orElse(null);
            }
            if (Mappers.doesRowContainColumn(row, "birthdate") && (birthDate = row.getTimestamp("birthdate")) != null) {
                user.setBirthdate(birthDate.getTime());
            }
            Set roles = Sets.create();
            if (Mappers.doesRowContainColumn(row, "roles")) {
                roles = row.getSet("roles", Role.class);
            }
            if (Mappers.doesRowContainColumn(row, "profile_image_id")) {
                String profileImageLink = row.getString("profile_image_id");
                user.setProfileImageLink(profileImageLink);
            }
            if (Mappers.doesRowContainColumn(row, "github_profile")) {
                String githubProfile = row.getString("github_profile");
                user.setGithubProfile(githubProfile);
            }
            if (Mappers.doesRowContainColumn(row, "time_account_created") && (timeCreated = row.getTimestamp("time_account_created")) != null) {
                user.setTimeUserJoined(timeCreated.getTime());
            }
            return user.setUserId(row.getUUID("user_id").toString()).setFirstName(row.getString("first_name")).setMiddleName(row.getString("middle_name")).setLastName(row.getString("last_name")).setEmail(email).setRoles(roles);
        };
    }

    private static boolean doesRowContainColumn(Row row, String column) {
        try {
            row.isNull(column);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

