/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TException;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@StrategyPattern(role=StrategyPattern.Role.INTERFACE)
public interface TokenRepository {
    public boolean containsToken(@NonEmpty String var1) throws TException;

    public AuthenticationToken getToken(@NonEmpty String var1) throws TException, InvalidTokenException;

    public void saveToken(@Required AuthenticationToken var1) throws TException;

    public List<AuthenticationToken> getTokensBelongingTo(@NonEmpty String var1) throws TException;

    public void deleteToken(@NonEmpty String var1) throws TException;

    default public boolean doesTokenBelongTo(@NonEmpty String tokenId, @NonEmpty String ownerId) throws InvalidTokenException, TException {
        Arguments.checkThat((Object)tokenId, (Object[])new String[]{ownerId}).throwing(InvalidArgumentException.class).usingMessage("tokenId and ownerId are required").are(StringAssertions.nonEmptyString());
        AuthenticationToken token = this.getToken(tokenId);
        Arguments.checkThat((Object)token).throwing(InvalidTokenException.class).is(RequestAssertions.tokenContainingOwnerId());
        return Objects.equals(ownerId, token.ownerId);
    }

    default public void deleteTokens(@Required List<String> tokenIds) throws TException {
        Arguments.checkThat(tokenIds).throwing(InvalidArgumentException.class).is(Assertions.notNull());
        List exceptions = Lists.create();
        tokenIds.parallelStream().forEach(tokenId -> {
            try {
                this.deleteToken((String)tokenId);
            }
            catch (TException ex) {
                exceptions.add(ex);
            }
        });
        if (!Lists.isEmpty((Collection)exceptions)) {
            throw (TException)((Object)Lists.oneOf((List)exceptions));
        }
    }

    default public void deleteTokensBelongingTo(@Required String ownerId) throws TException {
        Arguments.checkThat((Object)ownerId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        List exceptions = Lists.create();
        this.getTokensBelongingTo(ownerId).parallelStream().map(AuthenticationToken::getTokenId).forEach(id -> {
            try {
                this.deleteToken((String)id);
            }
            catch (TException ex) {
                exceptions.add(ex);
            }
        });
        if (!Lists.isEmpty((Collection)exceptions)) {
            throw (TException)((Object)Lists.oneOf((List)exceptions));
        }
    }
}

