/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.User;
import tech.aroma.thrift.service.AromaServiceConstants;
import tech.sirwellington.alchemy.annotations.arguments.Required;

public interface InboxRepository {
    default public void saveMessageForUser(@Required User user, @Required Message message) throws TException {
        this.saveMessageForUser(user, message, AromaServiceConstants.DEFAULT_INBOX_LIFETIME);
    }

    public void saveMessageForUser(@Required User var1, @Required Message var2, @Required LengthOfTime var3) throws TException;

    public List<Message> getMessagesForUser(@Required String var1) throws TException;

    default public List<Message> getMessagesForUser(@Required String userId, @Required String applicationId) throws TException {
        return this.getMessagesForUser(userId).stream().filter(msg -> Objects.equals(msg.applicationId, applicationId)).collect(Collectors.toList());
    }

    public boolean containsMessageInInbox(@Required String var1, @Required Message var2) throws TException;

    public void deleteMessageForUser(@Required String var1, @Required String var2) throws TException;

    public void deleteAllMessagesForUser(@Required String var1) throws TException;

    public long countInboxForUser(@Required String var1) throws TException;
}

