/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;

final class Step6Impl<ResponseType>
implements AlchemyRequest.Step6<ResponseType> {
    private static final Logger LOG = LoggerFactory.getLogger(Step6Impl.class);
    private final AlchemyHttpStateMachine stateMachine;
    private final HttpRequest request;
    private final Class<ResponseType> classOfResponseType;
    private final AlchemyRequest.OnSuccess<ResponseType> successCallback;
    private final AlchemyRequest.OnFailure failureCallback;

    Step6Impl(AlchemyHttpStateMachine stateMachine, HttpRequest request, Class<ResponseType> classOfResponseType, AlchemyRequest.OnSuccess<ResponseType> successCallback, AlchemyRequest.OnFailure failureCallback) {
        Arguments.checkThat((Object)stateMachine, (Object[])new Object[]{request, classOfResponseType, successCallback, failureCallback}).are(Assertions.notNull());
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        this.stateMachine = stateMachine;
        this.request = request;
        this.classOfResponseType = classOfResponseType;
        this.successCallback = successCallback;
        this.failureCallback = failureCallback;
    }

    @Override
    public void at(URL url) {
        Arguments.checkThat((Object)url).usingMessage("missing URL").is(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.Builder.from(this.request).usingUrl(url).build();
        this.stateMachine.executeAsync(requestCopy, this.classOfResponseType, this.successCallback, this.failureCallback);
    }

    public String toString() {
        return "Step6Impl{stateMachine=" + this.stateMachine + ", request=" + this.request + ", classOfResponseType=" + this.classOfResponseType + ", successCallback=" + this.successCallback + ", failureCallback=" + this.failureCallback + '}';
    }
}

