/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;

final class Step5Impl<ResponseType>
implements AlchemyRequest.Step5<ResponseType> {
    private static final Logger LOG = LoggerFactory.getLogger(Step5Impl.class);
    private final AlchemyHttpStateMachine stateMachine;
    private final HttpRequest request;
    private final Class<ResponseType> classOfResponseType;
    private final AlchemyRequest.OnSuccess<ResponseType> successCallback;

    public Step5Impl(AlchemyHttpStateMachine stateMachine, HttpRequest request, Class<ResponseType> classOfResponseType, AlchemyRequest.OnSuccess<ResponseType> successCallback) {
        Arguments.checkThat((Object)stateMachine, (Object[])new Object[]{request, classOfResponseType, successCallback}).are(Assertions.notNull());
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        this.stateMachine = stateMachine;
        this.request = request;
        this.classOfResponseType = classOfResponseType;
        this.successCallback = successCallback;
    }

    @Override
    public AlchemyRequest.Step6<ResponseType> onFailure(AlchemyRequest.OnFailure onFailureCallback) {
        Arguments.checkThat((Object)onFailureCallback).usingMessage("callback cannot be null").is(Assertions.notNull());
        return this.stateMachine.jumpToStep6(this.request, this.classOfResponseType, this.successCallback, onFailureCallback);
    }

    public String toString() {
        return "Step5Impl{stateMachine=" + this.stateMachine + ", request=" + this.request + ", classOfResponseType=" + this.classOfResponseType + ", successCallback=" + this.successCallback + '}';
    }
}

