/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

final class Step4Impl<ResponseType>
implements AlchemyRequest.Step4<ResponseType> {
    private static final Logger LOG = LoggerFactory.getLogger(Step4Impl.class);
    private final AlchemyHttpStateMachine stateMachine;
    private final HttpRequest request;
    private final Class<ResponseType> classOfResponseType;

    Step4Impl(AlchemyHttpStateMachine stateMachine, HttpRequest request, Class<ResponseType> classOfResponseType) {
        Arguments.checkThat((Object)stateMachine, (Object[])new Object[]{request, classOfResponseType}).are(Assertions.notNull());
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        this.stateMachine = stateMachine;
        this.request = request;
        this.classOfResponseType = classOfResponseType;
    }

    @Override
    public ResponseType at(URL url) throws AlchemyHttpException {
        Arguments.checkThat((Object)url).usingMessage("missing url").is(Assertions.notNull());
        HttpRequest newRequest = HttpRequest.Builder.from(this.request).usingUrl(url).build();
        return this.stateMachine.executeSync(newRequest, this.classOfResponseType);
    }

    @Override
    public AlchemyRequest.Step5<ResponseType> onSuccess(AlchemyRequest.OnSuccess<ResponseType> onSuccessCallback) {
        Arguments.checkThat(onSuccessCallback).usingMessage("callback cannot be null").is(Assertions.notNull());
        return this.stateMachine.jumpToStep5(this.request, this.classOfResponseType, onSuccessCallback);
    }

    public String toString() {
        return "Step4Impl{stateMachine=" + this.stateMachine + ", request=" + this.request + ", classOfResponseType=" + this.classOfResponseType + '}';
    }
}

