/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.http;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.http.AlchemyHttpStateMachine;
import tech.sirwellington.alchemy.http.AlchemyRequest;
import tech.sirwellington.alchemy.http.HttpAssertions;
import tech.sirwellington.alchemy.http.HttpRequest;
import tech.sirwellington.alchemy.http.HttpResponse;
import tech.sirwellington.alchemy.http.exceptions.AlchemyHttpException;

final class Step3Impl
implements AlchemyRequest.Step3 {
    private static final Logger LOG = LoggerFactory.getLogger(Step3Impl.class);
    private HttpRequest request;
    private final AlchemyHttpStateMachine stateMachine;

    Step3Impl(AlchemyHttpStateMachine stateMachine, HttpRequest request) {
        Arguments.checkThat((Object)stateMachine, (Object[])new Object[]{request}).are(Assertions.notNull());
        this.stateMachine = stateMachine;
        this.request = request;
    }

    @Override
    public AlchemyRequest.Step3 usingHeader(String key, String value) throws IllegalArgumentException {
        Arguments.checkThat((Object)key).usingMessage("missing key").is(StringAssertions.nonEmptyString());
        value = Strings.nullToEmpty((String)value);
        HashMap requestHeaders = Maps.newHashMap();
        if (this.request.getRequestHeaders() != null) {
            requestHeaders.putAll(this.request.getRequestHeaders());
        }
        requestHeaders.put(key, value);
        this.request = HttpRequest.Builder.from(this.request).usingRequestHeaders(requestHeaders).build();
        return this;
    }

    @Override
    public AlchemyRequest.Step3 usingQueryParam(String name, String value) throws IllegalArgumentException {
        Arguments.checkThat((Object)name, (Object[])new String[]{value}).usingMessage("missing name or value").are(StringAssertions.nonEmptyString());
        HashMap queryParams = Maps.newHashMap();
        if (this.request.getQueryParams() != null) {
            queryParams.putAll(this.request.getQueryParams());
        }
        queryParams.put(name, value);
        this.request = HttpRequest.Builder.from(this.request).usingQueryParams(queryParams).build();
        return this;
    }

    @Override
    public AlchemyRequest.Step3 followRedirects(int maxNumberOfTimes) throws IllegalArgumentException {
        Arguments.checkThat((Object)maxNumberOfTimes).is(NumberAssertions.greaterThanOrEqualTo((int)1));
        return this;
    }

    @Override
    public HttpResponse at(URL url) throws AlchemyHttpException {
        Arguments.checkThat((Object)url).is(Assertions.notNull());
        HttpRequest requestCopy = HttpRequest.Builder.from(this.request).usingUrl(url).build();
        return this.stateMachine.executeSync(requestCopy);
    }

    @Override
    public AlchemyRequest.Step5<HttpResponse> onSuccess(AlchemyRequest.OnSuccess<HttpResponse> onSuccessCallback) {
        Arguments.checkThat(onSuccessCallback).usingMessage("callback cannot be null").is(Assertions.notNull());
        return this.stateMachine.jumpToStep5(this.request, HttpResponse.class, onSuccessCallback);
    }

    @Override
    public <ResponseType> AlchemyRequest.Step4<ResponseType> expecting(Class<ResponseType> classOfResponseType) throws IllegalArgumentException {
        Arguments.checkThat(classOfResponseType).is(HttpAssertions.validResponseClass());
        return this.stateMachine.jumpToStep4(this.request, classOfResponseType);
    }

    public String toString() {
        return "Step3Impl{request=" + this.request + ", stateMachine=" + this.stateMachine + '}';
    }
}

